/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.util.Iterator;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.filter.NodeFilter;
import org.semanticweb.yars.stats.Analyser;
import org.semanticweb.yars.stats.InputAnalyser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultAnalyser
implements Analyser {
    private final Analyser _in;
    private final int[] _element;
    private final NodeFilter[] _key;

    public DefaultAnalyser(Iterator<Node[]> in) {
        this(in, null);
    }

    public DefaultAnalyser(Iterator<Node[]> in, NodeFilter[] key) {
        this._in = in instanceof Analyser ? (Analyser)in : new InputAnalyser(in);
        this._key = key;
        this._element = null;
    }

    public DefaultAnalyser(Analyser in) {
        this(in, null, null);
    }

    public DefaultAnalyser(Analyser in, NodeFilter[] key) {
        this(in, key, null);
    }

    public DefaultAnalyser(Analyser in, int[] element) {
        this(in, null, element);
    }

    public DefaultAnalyser(Analyser in, NodeFilter[] key, int[] element) {
        this._in = in;
        this._key = key;
        this._element = element;
    }

    @Override
    public boolean hasNext() {
        return this._in.hasNext();
    }

    @Override
    public Node[] next() {
        Node[] next = (Node[])this._in.next();
        Node[] analyseNodes = this.createIn(next);
        if (this.checkKey(analyseNodes)) {
            this.analyse(analyseNodes);
        }
        return next;
    }

    private boolean checkKey(Node[] in) {
        if (this._key == null) {
            return true;
        }
        for (int i = 0; i < this._key.length; ++i) {
            NodeFilter f = this._key[i];
            if (f == null || f.check(in[i])) continue;
            return false;
        }
        return true;
    }

    private Node[] createIn(Node[] in) {
        if (this._element == null) {
            return in;
        }
        Node[] na = new Node[this._element.length];
        int j = 0;
        for (int i : this._element) {
            na[j] = in[i];
            ++j;
        }
        return na;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

