/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.file.FileInput;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars2.rdfxml.RDFXMLParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RDFXMLGzInput
extends FileInput {
    public static int BUFFER = 8192;
    private String _base;

    public RDFXMLGzInput(File file, String baseURI) throws ParseException {
        super(file);
        this._base = baseURI;
        this._in = this.openFile();
    }

    @Override
    protected Iterator<Node[]> openFile() {
        if (this._base != null) {
            return this.openFile(this._base);
        }
        return null;
    }

    protected Iterator<Node[]> openFile(String base) {
        try {
            FileInputStream fis = new FileInputStream(this._f);
            GZIPInputStream gzis = new GZIPInputStream((InputStream)fis, BUFFER);
            this.toClose(gzis);
            RDFXMLParser rxxp = new RDFXMLParser(gzis, base);
            return rxxp;
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public RDFXMLGzInput copyOf() throws ParseException {
        return new RDFXMLGzInput(this._f, this._base);
    }
}

