/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.dt.string;

import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.dt.Datatype;
import org.semanticweb.yars.nx.dt.DatatypeParseException;
import org.semanticweb.yars.nx.namespace.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDLanguage
extends Datatype<Locale> {
    public static final Resource DT = XSD.LANGUAGE;
    public static final String REGEX = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    private Locale _l;
    private String _s;

    public XSDLanguage(String s) throws DatatypeParseException {
        if (s == null || s.isEmpty()) {
            throw new DatatypeParseException("Null value passed.", 0);
        }
        if (!Pattern.matches(REGEX, s)) {
            throw new DatatypeParseException("Lexical value does not correspond to regex [a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*.", s, DT, 20);
        }
        StringTokenizer tok = new StringTokenizer(s, "-");
        if (tok.countTokens() == 0) {
            throw new DatatypeParseException("Cannot parse according to '-'.", s, DT, 21);
        }
        String lang = tok.nextToken();
        if (lang.length() != 2) {
            throw new DatatypeParseException("Expecting first token to be of length 2: '" + lang + "'.", s, DT, 22);
        }
        if (tok.hasMoreTokens()) {
            String country = tok.nextToken();
            this._l = tok.hasMoreTokens() ? new Locale(lang, country, tok.nextToken()) : new Locale(lang, country);
        } else {
            this._l = new Locale(lang);
        }
        this._s = s;
    }

    @Override
    public String getCanonicalRepresentation() {
        return this._s;
    }

    @Override
    public Locale getValue() {
        return this._l;
    }

    public static void main(String[] args) throws DatatypeParseException {
        XSDLanguage dec = new XSDLanguage("en-US-asdjf");
        System.err.println(dec.getCanonicalRepresentation());
        System.err.println(dec.getValue());
    }
}

