/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.ParseException;

public class BNode
implements Serializable,
Node {
    public static String PREFIX = "_:";
    public static boolean PRETTY_PRINT = false;
    protected String _data;
    private static final long serialVersionUID = 6233987125715026425L;

    public BNode(String nodeid) {
        this(nodeid, false);
    }

    public BNode(String nodeid, boolean hasPrefix) {
        this._data = hasPrefix ? nodeid : (!nodeid.startsWith(PREFIX) ? PREFIX + nodeid : nodeid);
    }

    public String toString() {
        if (PRETTY_PRINT) {
            try {
                String[] conb = this.parseContextualBNode();
                return conb[1] + "@[" + conb[0] + "]";
            }
            catch (ParseException pe) {
                return BNode.unescapeForBNode(this._data.substring(PREFIX.length()));
            }
        }
        return this._data.substring(PREFIX.length());
    }

    public int hashCode() {
        return this._data.hashCode();
    }

    public String toN3() {
        return this._data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BNode) {
            return this._data.equals(((BNode)o)._data);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof BNode) {
            BNode b = (BNode)o;
            return this._data.compareTo(b._data);
        }
        if (o instanceof Resource) {
            return 0x3FFFFFFF;
        }
        if (o instanceof Literal) {
            return Integer.MAX_VALUE;
        }
        if (o instanceof Unbound) {
            return -1073741824;
        }
        if (o instanceof Variable) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type BNode but " + o.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (!this._data.startsWith(PREFIX)) {
            this._data = PREFIX + this._data;
        }
    }

    public String[] parseContextualBNode() throws ParseException {
        String d = this._data.substring(PREFIX.length());
        String[] uri = d.toString().split("xx");
        if (uri.length != 2) {
            throw new ParseException("This is not a valid context encoded BNode");
        }
        uri[0] = BNode.unescapeForBNode(uri[0]);
        uri[1] = BNode.unescapeForBNode(uri[1]);
        return uri;
    }

    public static String[] parseContextualBNode(BNode b) throws ParseException {
        String[] uri = b.toString().split("xx");
        if (uri.length != 2) {
            throw new ParseException("Not a valid context encoded BNode " + b);
        }
        uri[0] = BNode.unescapeForBNode(uri[0]);
        uri[1] = BNode.unescapeForBNode(uri[1]);
        return uri;
    }

    public static BNode createBNode(String docURI, String localID) {
        String escapedDU = BNode.escapeForBNode(docURI);
        String escapedLI = BNode.escapeForBNode(localID);
        return new BNode(escapedLI + "xx" + escapedDU);
    }

    public static BNode createBNode(String unescaped) {
        String escaped = BNode.escapeForBNode(unescaped);
        return new BNode(escaped);
    }

    public static String escapeForBNode(String unescaped) {
        try {
            return URLEncoder.encode(unescaped, "utf-8").replace("x", "x78").replace("-", "x2D").replace(".", "x2E").replace("_", "x5F").replace('%', 'x');
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String unescapeForBNode(String escaped) {
        try {
            return URLDecoder.decode(escaped.replace('x', '%'), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static void main(String[] args) throws ParseException {
        String unescaped = "http://asdj.com/-xx42xxx/%20thing/";
        System.err.println(BNode.escapeForBNode(unescaped));
        System.err.println(BNode.unescapeForBNode(BNode.escapeForBNode(unescaped)));
        System.err.println(BNode.createBNode(unescaped, "xx78x"));
        for (String s : BNode.parseContextualBNode(BNode.createBNode(unescaped, "xx78x"))) {
            System.err.println(s);
        }
    }
}

