/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tagcloud;

import de.xam.tagcloud.StatsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xydra.index.CollectionUtils;
import org.xydra.index.impl.CountingMap;
import org.xydra.index.impl.IntegerRange;
import org.xydra.index.iterator.ITransformer;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Frequency<T extends Comparable<T>> {
    private final SortedMap<T, Integer> tag2count = new TreeMap<T, Integer>();
    private int maxOccuringFrequency = 0;
    private static final Logger log = LoggerFactory.getLogger(Frequency.class);

    public void index(T object, Set<T> blacklist) {
        if (blacklist.contains(object)) {
            return;
        }
        Integer tagCount = (Integer)this.tag2count.get(object);
        if (tagCount == null) {
            tagCount = 0;
        }
        this.maxOccuringFrequency = Math.max(this.maxOccuringFrequency, tagCount + 1);
        this.tag2count.put(object, tagCount + 1);
    }

    public boolean deIndex(T object) {
        Integer tagCount = (Integer)this.tag2count.get(object);
        if (tagCount == null) {
            return false;
        }
        if (tagCount == 1) {
            this.tag2count.remove(object);
        } else {
            this.tag2count.put(object, tagCount - 1);
        }
        return true;
    }

    public boolean remove(T object) {
        return this.tag2count.remove(object) != null;
    }

    public void writeToAlphabeticList(Writer w) throws IOException {
        w.write("<ol class='alphabetic'>");
        for (Comparable s : this.tag2count.keySet()) {
            w.write("<li><span class='term'>" + s + "</span><span class='count'> (" + this.tag2count.get(s) + "x)</span></li>");
        }
        w.write("</ol>");
    }

    public void writeToTagCloud(Writer w, IntegerRange freqRange, int desiredTagNumber, Set<T> ignore, ITransformer<T, String> optionalStringTransformer, Comparator<T> optionalElementComparator) throws IOException {
        IntegerRange usedCountRange;
        log.info("Generating tagcloud for tags=" + desiredTagNumber + " freqRange=" + freqRange);
        int quotaLeftForTagCountMin = 0;
        if (desiredTagNumber > 0) {
            int tagsWithFrequencyF;
            CountingMap freq2members = new CountingMap();
            for (Integer freq : this.tag2count.values()) {
                freq2members.index((Object)freq);
            }
            int resultCount = 0;
            int f = this.maxOccuringFrequency;
            if (freqRange.getEnd() < f) {
                f = freqRange.getEnd();
            }
            usedCountRange = new IntegerRange(f, f);
            do {
                tagsWithFrequencyF = (Integer)freq2members.getCount((Object)f);
                usedCountRange.setStart(f);
            } while (--f >= 1 && (resultCount += tagsWithFrequencyF) < desiredTagNumber);
            quotaLeftForTagCountMin = desiredTagNumber - (resultCount - tagsWithFrequencyF);
            log.debug("Desired tag range " + desiredTagNumber + " -> tag counts " + usedCountRange + " plus " + quotaLeftForTagCountMin);
        } else {
            usedCountRange = freqRange;
        }
        assert (usedCountRange.getStart() >= 0) : "used=" + usedCountRange;
        w.write("<!--\n\n freqRange=" + freqRange + " desiredTagNumber=" + desiredTagNumber + " => usedCountRange=" + usedCountRange + " quotaLefForLowestFreq=" + quotaLeftForTagCountMin + "  \n\n-->");
        w.write("<div class='tagcloud'>");
        int tagCountMin = usedCountRange.getStart();
        int tagCountMax = usedCountRange.getEnd();
        double tagCountMin_log = Math.log(tagCountMin);
        if (tagCountMin_log < 0.0) {
            tagCountMin_log = 0.0;
        }
        double tagCountMax_log = Math.log(tagCountMax);
        List sortedTagList = optionalElementComparator == null ? CollectionUtils.toSortedList(this.tag2count.keySet()) : CollectionUtils.toSortedList(this.tag2count.keySet(), optionalElementComparator);
        for (Comparable s : sortedTagList) {
            double count_log;
            int tagCount;
            if (ignore.contains(s) || (tagCount = ((Integer)this.tag2count.get(s)).intValue()) < tagCountMin || tagCount > tagCountMax) continue;
            assert (tagCount >= tagCountMin && tagCount <= tagCountMax) : "min=" + tagCountMin + " count=" + tagCount + " max=" + tagCountMax;
            if (tagCount == tagCountMin) {
                if (quotaLeftForTagCountMin <= 0) continue;
                --quotaLeftForTagCountMin;
            }
            if ((count_log = Math.log(tagCount)) < 0.0) {
                count_log = 0.0;
            }
            double count01 = StatsUtils.normalize01(tagCountMin_log, tagCountMax_log, count_log, 0.5);
            int cssClass0_20 = StatsUtils.scale(count01, 0, 20);
            int fontSize100 = StatsUtils.scale(count01, 100, 460);
            int colorHue = StatsUtils.scale(count01, 210, 311);
            int alpha100 = StatsUtils.scale(count01, 50, 100);
            String style = "color: hsla(" + colorHue + ", 100%, 40%, " + (double)alpha100 / 100.0 + "); " + "font-size: " + (double)fontSize100 / 100.0 + "em;" + "position: relative; z-index: " + (21 - cssClass0_20) + ";";
            w.write("<span title='" + tagCount + "x' class='tag tag" + cssClass0_20 + "'" + "style='" + style + "'" + ">");
            if (optionalStringTransformer != null) {
                String transformed = (String)optionalStringTransformer.transform((Object)s);
                w.write(transformed);
            } else {
                w.write(s.toString());
            }
            w.write("</span>\n");
        }
        w.write("</div>");
    }

    public List<Map.Entry<T, Integer>> sortByFrequency() {
        ArrayList<Map.Entry<T, Integer>> list = new ArrayList<Map.Entry<T, Integer>>();
        list.addAll(this.tag2count.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<T, Integer>>(){

            @Override
            public int compare(Map.Entry<T, Integer> a, Map.Entry<T, Integer> b) {
                return b.getValue() - a.getValue();
            }
        });
        return list;
    }

    public void writeToTop100(Writer w) throws IOException {
        List<Map.Entry<T, Integer>> list = this.sortByFrequency();
        w.write("<ol>");
        for (int i = 0; i < 100 && i < list.size(); ++i) {
            Map.Entry<T, Integer> entry = list.get(i);
            w.write("<li><span class='term'>" + entry.getKey() + "</span><span class='count'> (" + entry.getValue() + "x)</span></li>");
        }
        w.write("</ol>");
    }
}

