/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl.xydra;

import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.CContentFactory;
import de.xam.cmodel.content.impl.ContentFactory;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CFactory;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.impl.AbstractFactory;
import de.xam.cmodel.fact.impl.mem.MemoryCTriple;
import de.xam.cmodel.fact.impl.xydra.XyFactSet;
import de.xam.cmodel.fact.impl.xydra.XySymbol;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.rmof.XWritableModel;
import org.xydra.base.rmof.XWritableObject;
import org.xydra.base.rmof.XWritableRepository;
import org.xydra.base.rmof.impl.memory.SimpleObject;
import org.xydra.base.value.XValue;
import org.xydra.core.model.impl.memory.IMemoryModel;
import org.xydra.core.model.impl.memory.MemoryRepository;

public class XyFactory
extends AbstractFactory
implements CFactory,
CContentFactory {
    private final XId repositoryId;
    private final XId actorId;
    private final String passwordHash;
    private MemoryRepository xrepo;

    public XyFactory(XId repositoryId, XId actorId, String passwordHash) {
        this.repositoryId = repositoryId;
        this.actorId = actorId;
        this.passwordHash = passwordHash;
        this.xrepo = this.createRepository();
    }

    private MemoryRepository createRepository() {
        return new MemoryRepository(this.actorId, this.passwordHash, this.repositoryId);
    }

    public void clearRepository() {
        this.xrepo = this.createRepository();
    }

    public MemoryRepository getRepository() {
        return this.xrepo;
    }

    @Override
    public CFactSet createFactSet(XId id) {
        IMemoryModel xmodel = this.xrepo.createModel(id);
        return new XyFactSet((XWritableRepository)this.xrepo, (XWritableModel)xmodel);
    }

    @Override
    public CTriple createTriple(XId s, XId p, XId o) {
        return new MemoryCTriple(s, p, o);
    }

    @Override
    public CSymbol createSymbol(XId id, CBrowserRenderableContent content, boolean isReference) {
        SimpleObject xo = new SimpleObject(Base.toAddress(null, null, (XId)id, null));
        XySymbol symbol = new XySymbol((XWritableObject)xo);
        symbol.setIsReference(isReference);
        symbol.setContent(content.getContentValue(), content.getContentTypeUri(), -1L);
        return symbol;
    }

    @Override
    public CContentFactory contentFactory() {
        return this;
    }

    @Override
    public CBrowserRenderableContent createStringContent(String content, String contentTypeUri) {
        return new ContentFactory().createStringContent(content, contentTypeUri);
    }

    @Override
    public CBrowserRenderableContent createBinaryContent(byte[] content, String contentTypeUri) {
        return new ContentFactory().createBinaryContent(content, contentTypeUri);
    }

    @Override
    public CBrowserRenderableContent createValueContent(XValue value) {
        return new ContentFactory().createValueContent(value);
    }
}

