/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl.mem;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.Iterators;
import de.xam.cmodel.content.CBrowserRenderableContent;
import de.xam.cmodel.content.CWritableBrowserRenderableContent;
import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFact;
import de.xam.cmodel.fact.CFactIndex;
import de.xam.cmodel.fact.CFactSet;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.FactSets;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.impl.ReferenceValues;
import de.xam.cmodel.fact.impl.mem.MemoryCTriple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;

public class MemoryFactSet
implements CFactSet,
CFactIndex {
    private final XId id;
    private final Set<CTriple> triples = new HashSet<CTriple>();
    private final Map<XId, CSymbol> symbols = new HashMap<XId, CSymbol>();
    private CFactSet contextModel;
    private final ReferenceValues<CBrowserRenderableContent> contentReferences = new ReferenceValues();

    public MemoryFactSet(XId id) {
        this.id = id;
    }

    public XId getId() {
        return this.id;
    }

    @Override
    public Iterator<CTriple> getTriples() {
        return this.triples.iterator();
    }

    @Override
    public Iterator<CSymbol> getSymbols() {
        return this.symbols.values().iterator();
    }

    @Override
    public String dump() {
        System.out.println("symbolMap.size = " + this.symbols.size() + "; tripleMap.size = " + this.triples.size());
        for (Map.Entry<XId, CSymbol> e : this.symbols.entrySet()) {
            System.out.println(e.getKey() + " --> '" + e.getValue() + "'" + (e.getValue().isReference() ? "[ID]" : ""));
        }
        System.out.println("=== Triples");
        Iterator<CTriple> tit = this.getTriples();
        while (tit.hasNext()) {
            System.out.println(FactSets.toString((CFactIndex)this, tit.next()));
        }
        return "";
    }

    @Override
    public boolean addTriple(CTriple triple) {
        return this.triples.add(triple);
    }

    public boolean addTriple(XId s, XId p, XId o) {
        return this.addTriple(new MemoryCTriple(s, p, o));
    }

    @Override
    public boolean removeTriple(CTriple triple) {
        return this.triples.remove(triple);
    }

    public boolean removeTriple(XId s, XId p, XId o) {
        return this.removeTriple(new MemoryCTriple(s, p, o));
    }

    @Override
    public void setContextModel(CFactSet context) {
        this.contextModel = context;
    }

    public void searchAndReplaceInStringValues(String search, String replace) {
        for (CSymbol symbol : this.symbols.values()) {
            String r;
            String s;
            CWritableBrowserRenderableContent content = symbol.getWritableContent();
            String contentTypeUri = content.getContentTypeUri();
            if (!ContentTypes.isStringType(contentTypeUri) || (s = content.getContentAsString()).equals(r = s.replace(search, replace))) continue;
            content.setContent(s, contentTypeUri, -1L);
        }
    }

    @Override
    public CFactIndex getContextModel() {
        return this.contextModel;
    }

    @Override
    public Iterator<CEntity> getEntities() {
        Iterator<CSymbol> symbolIt = this.getSymbols();
        Iterator<CTriple> tripleIt = this.getTriples();
        return Iterators.concat(symbolIt, tripleIt);
    }

    @Override
    public IChangeData getChangeData() {
        return null;
    }

    @Override
    public String toDebugString() {
        return null;
    }

    @Override
    public void addSymbol(CSymbol symbol) {
        if (symbol.isReference()) {
            this.contentReferences.addReferenceValue(symbol.getId(), symbol.getContent());
        }
        this.symbols.put(symbol.getId(), symbol);
    }

    @Override
    public void removeSymbol(CSymbol symbol) {
        if (symbol.isReference()) {
            this.contentReferences.removeReferenceValue(symbol.getContent());
        }
        this.symbols.remove(symbol.getId());
    }

    @Override
    public void addFact(CFact fact) {
        if (fact instanceof CSymbol) {
            this.addSymbol((CSymbol)fact);
        }
        if (fact instanceof CTriple) {
            this.addTriple((CTriple)((Object)fact));
        }
    }

    @Override
    public void removeFact(CFact fact) {
        if (fact instanceof CSymbol) {
            this.removeSymbol((CSymbol)fact);
        }
        if (fact instanceof CTriple) {
            this.removeTriple((CTriple)((Object)fact));
        }
    }

    @Override
    public void removeFact(XId factId) {
        CSymbol previousSymbol = this.symbols.remove(factId);
        if (previousSymbol.isReference()) {
            this.contentReferences.removeReferenceValue(previousSymbol.getContent());
        }
        this.triples.remove(factId);
    }

    @Override
    public CFactSet getWritableContextModel() {
        return this.contextModel;
    }

    @Override
    public CFact getFactById(XId factId) {
        CSymbol symbol = this.getSymbolById(factId);
        return symbol;
    }

    @Override
    public CSymbol getSymbolById(XId symbolId) {
        return this.symbols.get(symbolId);
    }

    @Override
    public void removeSymbol(XId symbolId) {
        this.symbols.remove(symbolId);
    }

    @Override
    public void addEntity(CEntity entity) {
        if (entity instanceof CSymbol) {
            this.addSymbol((CSymbol)entity);
        } else if (entity instanceof CTriple) {
            this.addTriple((CTriple)entity);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

