/*
 * Decompiled with CFR 0.152.
 */
package de.xam.cmodel.fact.impl;

import de.xam.cmodel.content.ContentTypes;
import de.xam.cmodel.content.Contents;
import de.xam.cmodel.content.IContentType;
import de.xam.cmodel.fact.IHasAttributes;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.cmodel.util.XydraUtils;
import de.xam.p13n.shared.time.TimeProvider;
import java.io.UnsupportedEncodingException;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;

public class AttributeContentUtils {
    public static void setContent(IHasAttributes hasAttributes, byte[] contentBytes, String contentTypeUri, long lastModified) {
        IContentType contentType = ContentTypes.parseUri(contentTypeUri);
        if (contentType.isStringType()) {
            String charset = contentType.getCharset();
            try {
                String s = new String(contentBytes, charset);
                AttributeContentUtils.setContent(hasAttributes, s, contentTypeUri, lastModified);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Error", e);
            }
        } else {
            AttributeContentUtils.setContent(hasAttributes, (XValue)XV.toValue((byte[])contentBytes), contentTypeUri, lastModified);
        }
    }

    public static boolean setContent(IHasAttributes hasAttributes, XValue contentValue, String contentTypeUri, long lastModified) {
        boolean changes = hasAttributes.setAttribute(VocabularyCModel.ATTRIBUTE_CONTENT_TYPE_URI, (XValue)XV.toValue((String)contentTypeUri));
        if (!(changes |= hasAttributes.setAttribute(VocabularyCModel.ATTRIBUTE_CONTENT_VALUE, contentValue))) {
            return false;
        }
        long lastModifiedUsed = lastModified;
        if (lastModifiedUsed == -1L) {
            lastModifiedUsed = TimeProvider.getCurrentTimeInMillis();
        }
        if (AttributeContentUtils.getLongProperty(hasAttributes, VocabularyCModel.ATTRIBUTE_CREATION_DATE) == -1L) {
            hasAttributes.setAttribute(VocabularyCModel.ATTRIBUTE_CREATION_DATE, (XValue)XV.toValue((long)lastModifiedUsed));
        } else {
            hasAttributes.setAttribute(VocabularyCModel.ATTRIBUTE_LAST_MODIFIED, (XValue)XV.toValue((long)lastModifiedUsed));
        }
        return true;
    }

    public static boolean getBooleanProperty(IHasAttributes hasAttributes, XId attributeId) {
        return XydraUtils.toBoolean(hasAttributes.getAttribute(attributeId));
    }

    public static long getLongProperty(IHasAttributes hasAttributes, XId propertyId) {
        return XydraUtils.toLong(hasAttributes.getAttribute(propertyId));
    }

    public static long getContentLength(IHasAttributes hasAttributes) {
        XValue value = hasAttributes.getAttribute(VocabularyCModel.ATTRIBUTE_CONTENT_LENGTH);
        if (value == null) {
            long len = Contents.getContentLength(value);
            AttributeContentUtils.setAttribute(hasAttributes, VocabularyCModel.ATTRIBUTE_CONTENT_LENGTH, len);
            return len;
        }
        return XydraUtils.toLong(value);
    }

    public static void setAttribute(IHasAttributes hasAttributes, XId propertyId, long longValue) {
        hasAttributes.setAttribute(propertyId, (XValue)XV.toValue((long)longValue));
    }

    public static void setContent(IHasAttributes hasAttributes, String contentString, String contentTypeUri, long lastModified) {
        AttributeContentUtils.setContent(hasAttributes, (XValue)XV.toValue((String)contentString), contentTypeUri, lastModified);
    }
}

