/*
 * Decompiled with CFR 0.152.
 */
package de.xam.vocabulary;

import org.xydra.base.Base;
import org.xydra.base.XId;

public class VocabularyTerm
implements Comparable<VocabularyTerm> {
    private final XId id;
    private final String namespace;
    private final String prefix;
    private final String localName;
    private String label;
    private boolean deprecated = false;

    public VocabularyTerm(String namespace, String prefix, String localName) {
        assert (localName != null);
        this.namespace = namespace;
        this.prefix = prefix;
        this.localName = localName;
        String idStr = localName;
        if (prefix != null) {
            idStr = prefix + "-" + idStr;
        }
        if (namespace != null) {
            idStr = namespace + "-" + idStr;
        }
        this.id = Base.toId((String)idStr);
    }

    public XId id() {
        return this.id;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.id().toString();
        }
        return this.label;
    }

    public String toString() {
        return "VocabularyTerm [namespace=" + this.namespace + ", prefix=" + this.prefix + ", localName=" + this.localName + "] -> id='" + this.id + "'";
    }

    public VocabularyTerm setLabel(String label) {
        this.label = label;
        return this;
    }

    @Override
    public int compareTo(VocabularyTerm o) {
        if (o == null) {
            return 1;
        }
        return this.id.compareTo((Object)o.id);
    }

    public VocabularyTerm markAsDeprecated() {
        this.deprecated = true;
        return this;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

