/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.query;

import de.xam.cmodel.util.CUtils;
import de.xam.dwz1.DWZ;
import de.xam.dwz1.webgui.Router;
import de.xam.dwz1.webgui.server.query.TableRow;
import de.xam.dwzmodel.DwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.htmlwidgets.ToHtml;
import de.xam.htmlwidgets.elements.Link;
import de.xam.htmlwidgets.elements.Span;
import de.xam.htmlwidgets.elements.form.Form;
import de.xam.htmlwidgets.parts.Attribute;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.mybase.model.inference.IInfModel;
import de.xam.tokenpipe.user.pipe.link.spi.ILinkListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.base.value.XValue;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.MapIndex;
import org.xydra.index.impl.SerializableMapSetIndex;
import org.xydra.index.impl.SmallEntrySetFactory;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.ITriple;

public class TableQuery {
    private final List<XId> predicates;
    private final List<XId> subjects;
    private final IItemSet itemSet;
    private final IInfModel infModel;
    private static final ILinkListener.LinkCause linkCause = ILinkListener.LinkCause.query;

    public TableQuery(IItemSet itemSet, IInfModel infModel, List<XId> subjects, List<XId> predicates) {
        this.subjects = subjects;
        this.predicates = predicates;
        this.itemSet = itemSet;
        this.infModel = infModel;
    }

    public String toHtml() {
        boolean columnsSubjects = this.subjects.size() <= this.predicates.size();
        return this.toHtml(columnsSubjects);
    }

    public String toHtml(boolean columnsSubjects) {
        StringBuilder b = new StringBuilder();
        b.append("<table class='table semantic-table'>\n");
        if (columnsSubjects) {
            this.appendHtmlColumnsSubjects(b);
        } else {
            this.appendHtmlColumnsPredicates(b);
        }
        b.append("</table>");
        return b.toString();
    }

    private void appendHtmlColumnsSubjects(StringBuilder b) {
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet, MyBaseComponent.InfModel}).readLock().lock();
        DWZ dwz = DWZ.get();
        b.append("  <tr>\n");
        b.append("    <th>&nbsp;</th>\n");
        for (XId s : this.subjects) {
            b.append("    <th>");
            b.append((CharSequence)DwzModel.toLink((XId)s, (ILinkListener.LinkCause)linkCause, (String[])new String[0]));
            b.append("</th>\n");
        }
        b.append("  </tr>\n");
        for (XId p : this.predicates) {
            b.append("  <tr>\n");
            b.append("    <td>");
            b.append((CharSequence)DwzModel.toLink((XId)p, (ILinkListener.LinkCause)linkCause, (String[])new String[0]));
            b.append("</td>\n");
            boolean this_p_isUsedAsProperty = false;
            for (XId s : this.subjects) {
                Set props = this.itemSet.getPropertiesFor(s, p);
                if (props.size() <= 0) continue;
                this_p_isUsedAsProperty = true;
                break;
            }
            for (XId s : this.subjects) {
                b.append("    <td>\n");
                boolean needLineBreak = false;
                Set props = this.itemSet.getPropertiesFor(s, p);
                if (props.size() > 0) {
                    assert (props.size() == 1);
                    IProperty property = (IProperty)props.iterator().next();
                    Form form = new Form(null, Form.METHOD.POST, Router.get().url_item_property(s, p));
                    String propertyValueStr = property.getPropertyValue().toString();
                    form.inputText("", "oValue", propertyValueStr).addAttribute("required", "required");
                    Link link = (Link)new Link(null, "", Router.get().url_entity_delete(property.getId()), new Attribute[]{new Attribute("title", "Delete this property")}).cssClasses(new String[]{"remove"});
                    Span span = new Span((ToHtml)link, new Attribute[0]);
                    span.cssClasses(new String[]{"glyphicon glyphicon-remove"});
                    link.html((ToHtml)span);
                    form.html((ToHtml)link);
                    form.inputSubmit("!");
                    b.append(form.toHtml("  "));
                    needLineBreak = true;
                } else if (this_p_isUsedAsProperty) {
                    Form form = new Form(null, Form.METHOD.POST, Router.get().url_item_property(s, p));
                    String propertyValueStr = "";
                    form.inputText("", "oValue", "").addAttribute("required", "required");
                    form.inputSubmit("!");
                    b.append(form.toHtml("  "));
                    needLineBreak = true;
                }
                if (needLineBreak) {
                    b.append("<br/>\n");
                }
                Iterator it = this.infModel.getTriples(s, p, null);
                ArrayList<XId> os = new ArrayList<XId>();
                while (it.hasNext()) {
                    ITriple triple = (ITriple)it.next();
                    if (this.isPropertyTriple((ITriple<XId, XId, XId>)triple)) continue;
                    XId o = (XId)triple.o();
                    os.add(o);
                }
                TableQuery.appendObjects(dwz, b, os.iterator());
                b.append("    </td>\n");
            }
            b.append("  </tr>\n");
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet, MyBaseComponent.InfModel}).readLock().unlock();
    }

    private static void appendObjects(DWZ dwz, StringBuilder b, Iterator<XId> it) {
        ArrayList oList = Iterators.toArrayList(it);
        DwzModel.sortByContent((List)oList);
        Iterator oIt = oList.iterator();
        while (oIt.hasNext()) {
            XId oId = (XId)oIt.next();
            b.append((CharSequence)DwzModel.toLink((XId)oId, (ILinkListener.LinkCause)linkCause, (String[])new String[0]));
            if (!oIt.hasNext()) continue;
            b.append("<br/>\n");
        }
    }

    private boolean isPropertyTriple(ITriple<XId, XId, XId> triple) {
        Set props = this.itemSet.getPropertiesFor((XId)triple.s(), (XId)triple.p());
        return !props.isEmpty();
    }

    private void appendHtmlColumnsPredicates(StringBuilder b) {
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet, MyBaseComponent.InfModel}).readLock().lock();
        DWZ dwz = DWZ.get();
        b.append("  <tr>\n");
        b.append("    <th>&nbsp;</th>\n");
        for (XId p : this.predicates) {
            b.append("    <th>");
            b.append((CharSequence)DwzModel.toLink((XId)p, (ILinkListener.LinkCause)linkCause, (String[])new String[0]));
            b.append("</th>\n");
        }
        b.append("  </tr>\n");
        for (XId s : this.subjects) {
            MapIndex p_value = new MapIndex();
            SerializableMapSetIndex p_o = new SerializableMapSetIndex((Factory)new SmallEntrySetFactory());
            Set props = this.itemSet.getPropertiesFor(s, null);
            HashSet<byte[]> propTriples = new HashSet<byte[]>();
            for (IProperty prop : props) {
                assert (prop.getWritableContent().getContentValue() != null);
                p_value.index((Object)prop.getPropertyKey(), (Object)prop.getPropertyValue());
                propTriples.add(CUtils.combine((XId)prop.getSourceEntityId(), (XId)prop.getPropertyKey()));
            }
            Iterator tit = this.infModel.getTriples(s, null, null);
            while (tit.hasNext()) {
                ITriple triple = (ITriple)tit.next();
                if (propTriples.contains(CUtils.getTripleId((ITriple)triple))) continue;
                p_o.index(triple.p(), triple.o());
            }
            b.append("  <tr>\n");
            b.append("    <td>");
            b.append((CharSequence)DwzModel.toLink((XId)s, (ILinkListener.LinkCause)linkCause, (String[])new String[0]));
            b.append("</td>\n");
            for (XId p : this.predicates) {
                b.append("    <td>\n");
                XValue value = (XValue)p_value.lookup((Object)p);
                b.append("<form action='" + Router.get().url_item_property(s, p) + "' method='POST'>\n" + "<input type='text' name='oValue' value='" + (value == null ? "" : value.toString()) + "' size='15'>\n" + "<input type='submit' value='!'>\n" + "</form>");
                b.append("<br/>\n");
                IEntrySet os = p_o.lookup((Object)p);
                if (os != null) {
                    TableQuery.appendObjects(dwz, b, os.iterator());
                }
                b.append("    </td>\n");
            }
            b.append("  </tr>\n");
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.ItemSet, MyBaseComponent.InfModel}).readLock().unlock();
    }

    public Iterator<XId> getPredicates() {
        return this.predicates.iterator();
    }

    public Iterator<TableRow> getRows() {
        return Iterators.transform(this.subjects.iterator(), (ITransformer)new ITransformer<XId, TableRow>(){

            public TableRow transform(XId s) {
                return new TableRow(TableQuery.this.itemSet, TableQuery.this.infModel, TableQuery.this, s);
            }
        });
    }
}

