/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.query;

import com.calpano.common.server.util.DebugMode;
import de.xam.dwzmodel.DwzModel;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.IItem;
import de.xam.json.JON;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.ITripleStats;
import de.xam.mybase.model.search.SearchEngines;
import de.xam.texthtml.text.Unicodes;
import de.xam.textsearch.Match;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.xydra.base.XId;
import org.xydra.index.impl.CountingMap;
import org.xydra.index.iterator.IFilter;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;

public class AutocompleteResource {
    private static final Logger log = LoggerFactory.getLogger(AutocompleteResource.class);

    public static void autocompletePrefetch(IRestlessContext ctx, HttpServletResponse response, String optionalPreferredFilterName) throws IOException {
        IFilter<XId> optionalPreferredFilter = AutocompleteResource.toFilter(optionalPreferredFilterName);
        Set matches = DwzModel.autocompletePrefetchMatches(optionalPreferredFilter);
        AutocompleteResource.writeToJson(matches, ctx.getResponse());
    }

    private static IFilter<XId> toFilter(String optionalFilterName) {
        if (optionalFilterName == null || optionalFilterName.equals("")) {
            return null;
        }
        IMyBase myBase = ModuleManager.get().getMyBase();
        SearchEngines.ResultFilter resultFilter = SearchEngines.ResultFilter.valueOf((String)optionalFilterName);
        return SearchEngines.toFilter((ITripleStats)myBase.tripleStats(), (SearchEngines.ResultFilter)resultFilter);
    }

    public static void autocomplete(IRestlessContext ctx, String prefix, int maxResults, String optionalPreferredFilterName) throws IOException {
        if (prefix == null) {
            AutocompleteResource.writeToJson(Collections.EMPTY_LIST, ctx.getResponse());
            return;
        }
        IFilter<XId> optionalFilter = AutocompleteResource.toFilter(optionalPreferredFilterName);
        List matches = DwzModel.autocompleteMatches((String)prefix, (int)maxResults, optionalFilter);
        AutocompleteResource.writeToJson(matches, ctx.getResponse());
    }

    private static void writeToJson(Collection<Match<XId>> matches, HttpServletResponse res) throws IOException {
        ServletOutputStream out = res.getOutputStream();
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, Unicodes.UTF8);
        CountingMap contentCount = new CountingMap();
        for (Match<XId> match : matches) {
            XId id = (XId)match.getValue();
            IItem item = ModuleManager.get().getMyBase().itemSet().getItemById(id);
            if (item == null) {
                log.warn("Item '" + id + "' was null");
                return;
            }
            String content = item.getDisplayString();
            contentCount.index((Object)content);
        }
        JON jon = JON.create().setTypeAsArray();
        for (Match<XId> match : matches) {
            JON entry = jon.createChildValue();
            XId id = (XId)match.getValue();
            entry.putString("xid", new String[]{id.toString()});
            String content = ModuleManager.get().getMyBase().itemSet().getItemById(id).getContent().getContentAsString();
            if ((Integer)contentCount.getCount((Object)content) > 1) {
                content = content + " (" + id + ")";
            }
            if (DebugMode.isOn()) {
                content = content + " [q=" + match.q() + "]";
            }
            entry.putString("value", new String[]{content});
            entry.goTo("tokens").add((Collection)match.getMatchedStrings());
        }
        w.write(jon.toJson(false));
        w.flush();
        w.close();
        out.close();
    }
}

