/*
 * Decompiled with CFR 0.152.
 */
package de.xam.dwz1.webgui.server.ext;

import com.calpano.common.server.local.ShutdownServer;
import de.xam.cmodel.VocabularyForVocabularies;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.dwz1.webgui.DwzBaseVelocitySupport;
import de.xam.dwz1.webgui.RenderTool;
import de.xam.dwz1.webgui.server.ext.GraphVelocitySupport;
import de.xam.dwzmodel.api.ConfParamsDwzModel;
import de.xam.dwzmodel.api.VocabularyContextGraph;
import de.xam.dwzmodel.graph2.Graphs;
import de.xam.dwzmodel.state.ModuleManager;
import de.xam.itemset.Attributes;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.impl.ItemSets;
import de.xam.json.JON;
import de.xam.mybase.model.MyBases;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.api.MyBaseComponent;
import de.xam.p13n.shared.Personalisation;
import de.xam.texthtml.text.EncTool;
import de.xam.texthtml.text.TextTool;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.common.NanoClock;
import org.xydra.csv.impl.memory.CsvTable;
import org.xydra.csv.impl.memory.Row;
import org.xydra.env.Env;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;
import org.xydra.restless.IRestlessContext;
import org.xydra.restless.RestlessUtils;

public class ExtResource {
    private static final Logger log = LoggerFactory.getLogger(ExtResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void d3(IRestlessContext ctx, HttpServletResponse res, String itemIdStr, String maxDepthStr, String maxNodesStr) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("<< " + RestlessUtils.getFullRequestUri((HttpServletRequest)ctx.getRequest()));
        }
        String itemIdStrDec = TextTool.urlDecode((String)itemIdStr);
        XId itemId = Base.toId((String)itemIdStrDec);
        int maxDepth = Integer.parseInt(maxDepthStr);
        int maxNodes = Integer.parseInt(maxNodesStr);
        res.setContentType("application/json");
        res.setCharacterEncoding("UTF-8");
        PrintWriter w = res.getWriter();
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().lock();
        String jsonString = null;
        try {
            IMyBase myBase = ModuleManager.get().getMyBase();
            IItem item = myBase.itemSet().getItemById(itemId);
            if (item != null) {
                String mn;
                String md = Attributes.getStringAttribute((IEntity)item, (XId)VocabularyContextGraph.ATTRIBUTE_MAX_DEPTH);
                if (md != null) {
                    maxDepth = Integer.parseInt(md);
                }
                if ((mn = Attributes.getStringAttribute((IEntity)item, (XId)VocabularyContextGraph.ATTRIBUTE_MAX_NODES)) != null) {
                    maxNodes = Integer.parseInt(mn);
                }
            }
            TreeSet<XId> startItemIds = new TreeSet<XId>();
            startItemIds.add(itemId);
            JON jon = Graphs.createGraphAsJSON((IMyBase)myBase, startItemIds, new TreeSet(), (int)maxDepth, (int)maxNodes);
            jsonString = jon.toJson(true);
        }
        catch (Throwable t) {
            try {
                log.warn("ohoh", t);
            }
            catch (Throwable throwable) {
                ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
                throw throwable;
            }
            ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
        if (jsonString != null) {
            ((Writer)w).write(jsonString);
        }
        ((Writer)w).close();
    }

    public void css(IRestlessContext ctx) throws IOException {
        log.info("Generating CSS for D3 graph");
        NanoClock clock = new NanoClock();
        clock.start();
        StringBuilder b = new StringBuilder();
        b.append("/* auto-generated CSS */\n");
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().lock();
        IMyBase myBase = ModuleManager.get().getMyBase();
        XId css_attributeId = VocabularyContextGraph.ATTRIBUTE_STYLE_CSS;
        Set props = myBase.itemSet().getPropertiesFor(null, css_attributeId);
        clock.stopAndStart("getProps");
        log.info("Processing props");
        for (IProperty property : props) {
            IItem item;
            assert (property.getWritableContent().getContentValue() != null);
            XId itemId = property.getSourceEntityId();
            if (itemId.equals((Object)VocabularyForVocabularies.DUMMY_ITEM_ID) || (item = myBase.itemSet().getItemById(itemId)) == null) continue;
            log.info("Processing prop item " + item.getId());
            String cssClass = EncTool.escapeCssIdOrClassname((String)itemId.toString());
            String ruleBody = Attributes.getStringAttribute((IEntity)item, (XId)css_attributeId);
            if (ruleBody != null) {
                HashMap<String, String> simpleMap = new HashMap<String, String>();
                simpleMap.put("this", cssClass);
                String interpolated = TextTool.interpolate((String)ruleBody, simpleMap);
                b.append(interpolated);
            }
            b.append("\n");
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
        clock.stopAndStart("doneWithProps");
        ctx.getResponse().setContentType("text/css");
        PrintWriter w = ctx.getResponse().getWriter();
        ((Writer)w).write(b.toString());
        ((Writer)w).close();
        log.info("css timing " + clock.getStats());
    }

    public void importCsv(IRestlessContext ctx, String absoluteLocalPath, String encoding) throws IOException {
        PrintWriter w = ctx.getResponse().getWriter();
        File f = new File(absoluteLocalPath);
        if (!f.exists()) {
            ((Writer)w).write("File " + f.getAbsolutePath() + " not found.");
            ((Writer)w).close();
            return;
        }
        CsvTable table = new CsvTable(true);
        table.readFrom(f, encoding);
        Row header = table.getHeaderRow();
        if (header == null) {
            ((Writer)w).write("Found no header row (no first row = no rows?)");
            ((Writer)w).close();
            return;
        }
        if (!table.getColumnNames().contains("item")) {
            ((Writer)w).write("Found no column 'item'");
            ((Writer)w).close();
            return;
        }
        IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)"ImportFromCsv", (String)"ExtResource");
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().lock();
        IMyBase myBase = ModuleManager.get().getMyBase();
        Iterator rowIt = table.getDataRows();
        while (rowIt.hasNext()) {
            Row data = (Row)rowIt.next();
            String itemName = data.getValue("item");
            IItem item = MyBases.getOrCreateNameItem((IMyBase)myBase, (String)itemName, (IChangeData)changeData);
            ((Writer)w).write("\nItem '" + item.getDisplayString() + "': ");
            for (String relOrPropName : table.getColumnNamesSorted()) {
                if (relOrPropName.equals("item")) continue;
                IItem relOrProp = MyBases.getOrCreateNameItem((IMyBase)myBase, (String)relOrPropName, (IChangeData)changeData);
                String value = data.getValue(relOrPropName);
                if (value.equals("null")) continue;
                if (relOrPropName.startsWith("prop")) {
                    item.setAttribute(relOrProp.getId(), (XValue)XV.toValue((String)value));
                } else {
                    IItem target = MyBases.getOrCreateNameItem((IMyBase)myBase, (String)value, (IChangeData)changeData);
                    ItemSets.addRelated((IItemSet)myBase.itemSet(), (XId)item.getId(), (XId)relOrProp.getId(), (XId)target.getId(), (IChangeData)changeData);
                }
                ((Writer)w).write(" '" + relOrProp.getDisplayString() + "' = '" + value + "';");
            }
        }
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).writeLock().unlock();
        ((Writer)w).write("\nDone.");
        ((Writer)w).close();
    }

    public static void main(String[] args) {
        for (Charset a : Charset.availableCharsets().values()) {
            System.out.println(a);
        }
        System.out.println(Charset.defaultCharset().toString());
    }

    public void graph(IRestlessContext ctx, String itemIdStr, String maxDepthStr, String maxNodesStr) throws IOException {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        GraphVelocitySupport velocitySupport = new GraphVelocitySupport(p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), "graph", itemIdStr);
        velocitySupport.setTitle("Context Graph");
        velocitySupport.setCanvas(ctx.getRequest().getParameter("canvas"));
        RenderTool.renderPageWithTemplate(ctx, velocitySupport, "de.xam.dwz1.templates.graph");
    }

    public void raw(IRestlessContext ctx, String itemId) throws IOException {
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().lock();
        IMyBase myBase = ModuleManager.get().getMyBase();
        StringBuilder b = MyBases.toDebugString((IMyBase)myBase, (XId)Base.toId((String)itemId));
        ModuleManager.get().locks(new MyBaseComponent[]{MyBaseComponent.MyBase}).readLock().unlock();
        PrintWriter w = ctx.getResponse().getWriter();
        ((Writer)w).write(b.toString());
        ((Writer)w).close();
    }

    public void shutdown(IRestlessContext ctx) throws IOException {
        Personalisation p13n = ModuleManager.get().getPersonalisation();
        DwzBaseVelocitySupport velocitySupport = new DwzBaseVelocitySupport(p13n, ConfParamsDwzModel.MESSAGE_PACKAGES, ctx.getRequestIdentifier(), "shutdown", "shutdown", false);
        velocitySupport.setTitle("DenkWerkZeug");
        RenderTool.renderPageWithTemplate(ctx, velocitySupport, "de.xam.dwz1.templates.shutdown");
        try {
            int shutdownPort = Env.get().conf().getInt("shutDownServerPort");
            ShutdownServer.sendStopToLocalhost((int)shutdownPort);
        }
        catch (SocketException e) {
            log.info("Shutdown Server socket was already closed");
        }
    }
}

