/*
 * Decompiled with CFR 0.152.
 */
package de.xam.binstore_zip;

import de.xam.binstore_zip.IArchive;
import de.xam.files.FileTools;
import de.xam.texthtml.text.Unicodes;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;

public class DesktopArchive
implements IArchive {
    private final boolean readFromZip;
    private final Properties metaProperties = new Properties();
    private final File zipFile;
    private final File workDir;
    private boolean isUnderConstruction;
    public static final String META_DATA_BLOBNAME = "_meta.properties";

    private DesktopArchive(File zipFile, File workDir, boolean isUnderConstruction) {
        this.zipFile = zipFile;
        this.isUnderConstruction = isUnderConstruction;
        this.workDir = workDir;
        this.readFromZip = false;
    }

    public static DesktopArchive open(boolean write, File zipFile, File tempWorkDir) {
        return new DesktopArchive(zipFile, tempWorkDir, write);
    }

    @Override
    public long getLastModified() {
        if (!this.zipFile.exists()) {
            return -1L;
        }
        return this.zipFile.lastModified();
    }

    @Override
    public Map<String, String> getMetaData() throws IOException {
        block2: {
            try {
                InputStream is = this.openInputStream(META_DATA_BLOBNAME);
                InputStreamReader r = new InputStreamReader(is, Unicodes.UTF8);
                this.metaProperties.load(r);
            }
            catch (IllegalStateException e) {
                if (this.isUnderConstruction()) break block2;
                return Collections.EMPTY_MAP;
            }
        }
        return new MapOfStringOnProperties(this.metaProperties);
    }

    @Override
    public InputStream openInputStream(String blobName) throws IOException {
        File tempFile;
        if (!this.isUnderConstruction()) {
            if (this.readFromZip) {
                InputStream is = FileTools.readFromZip((File)this.zipFile, (String)blobName);
                return is;
            }
            FileTools.unzip((File)this.zipFile, (File)this.workDir);
        }
        if (!(tempFile = this.toBlobFile(blobName)).exists()) {
            throw new IllegalStateException("No blob named '" + blobName + "' could be found (" + tempFile.getAbsolutePath() + ")");
        }
        FileInputStream fis = new FileInputStream(tempFile);
        return fis;
    }

    private File toBlobFile(String blobName) {
        return new File(this.workDir, blobName);
    }

    @Override
    public OutputStream openOutputStream(String blobName) throws IOException {
        if (!this.isUnderConstruction()) {
            throw new IllegalStateException();
        }
        File blobFile = this.toBlobFile(blobName);
        blobFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(blobFile);
        return fos;
    }

    @Override
    public boolean isUnderConstruction() {
        return this.isUnderConstruction;
    }

    @Override
    public void commitVersion() throws IOException {
        if (!this.isUnderConstruction()) {
            throw new IllegalStateException();
        }
        this.writeMetaData();
        FileTools.zip((File)this.workDir, (FileFilter)FileTools.ALL_FILES_AND_DIRS_FILTER, (File)this.zipFile, null);
        this.isUnderConstruction = false;
    }

    public void writeMetaData() throws IOException {
        File metaFile = this.toBlobFile(META_DATA_BLOBNAME);
        FileOutputStream fos = new FileOutputStream(metaFile);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, Unicodes.UTF8);
        this.metaProperties.store(w, "");
        w.close();
        fos.close();
    }

    @Override
    public void abortVersion() throws IllegalStateException, IOException {
        if (!this.isUnderConstruction()) {
            throw new IllegalStateException();
        }
        FileUtils.deleteDirectory((File)this.workDir);
        this.isUnderConstruction = false;
    }

    public static void main(String[] args) throws IOException {
        File testDir = new File("/Users/xamde/_data_/_p_/_git/DwzGit/de.xam.dwz1/target/tempkfile");
        File dirA = new File(testDir, "aaa");
        File aZip = new File(dirA, "a.zip");
        File a1Temp = new File(dirA, "tempdir1");
        DesktopArchive a = DesktopArchive.open(true, aZip, a1Temp);
        long aModified = a.getLastModified();
        assert (aModified != -1L);
        Map<String, String> aMeta = a.getMetaData();
        aMeta.put("akey", "avalue");
        aMeta.put("bkey", "bvalue");
        OutputStream aOs = a.openOutputStream("aa");
        OutputStreamWriter aOsw = new OutputStreamWriter(aOs, Unicodes.UTF8);
        String fooBar = "Foo Bar AAA";
        aOsw.write("Foo Bar AAA");
        aOsw.close();
        aOs.close();
        a.commitVersion();
        File a2Temp = new File(dirA, "tempdir2");
        DesktopArchive a2 = DesktopArchive.open(false, aZip, a2Temp);
        InputStream is2 = a2.openInputStream("aa");
        String fooBar2 = IOUtils.toString((InputStream)is2, (Charset)Unicodes.UTF8);
        File a3Temp = new File(dirA, "tempdir3");
        DesktopArchive a3 = DesktopArchive.open(false, aZip, a3Temp);
        InputStream is3 = a3.openInputStream("aa");
        String fooBar3 = IOUtils.toString((InputStream)is3, (Charset)Unicodes.UTF8);
        System.out.println("Done Foo Bar AAA " + fooBar2 + " " + fooBar3);
    }

    static class MapOfStringOnProperties
    implements Map<String, String> {
        private final Properties p;

        public MapOfStringOnProperties(Properties p) {
            this.p = p;
        }

        @Override
        public int size() {
            return this.p.size();
        }

        @Override
        public boolean isEmpty() {
            return this.p.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.p.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.p.containsValue(value);
        }

        @Override
        public String get(Object key) {
            return (String)this.p.get(key);
        }

        @Override
        public String put(String key, String value) {
            return (String)this.p.put(key, value);
        }

        @Override
        public String remove(Object key) {
            return (String)this.p.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            this.p.putAll(m);
        }

        @Override
        public void clear() {
            this.p.clear();
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> set = new HashSet<String>();
            Iterators.addAll(this.keyIterator(), set);
            return set;
        }

        public Iterator<String> keyIterator() {
            return Iterators.transform(this.p.keySet().iterator(), (ITransformer)new ITransformer<Object, String>(){

                public String transform(Object in) {
                    return (String)in;
                }
            });
        }

        public Iterator<String> valueIterator() {
            return Iterators.transform(this.p.values().iterator(), (ITransformer)new ITransformer<Object, String>(){

                public String transform(Object in) {
                    return (String)in;
                }
            });
        }

        @Override
        public Collection<String> values() {
            HashSet<String> set = new HashSet<String>();
            Iterators.addAll(this.valueIterator(), set);
            return set;
        }

        public Iterator<Map.Entry<String, String>> entryIterator() {
            return Iterators.transform(this.p.entrySet().iterator(), (ITransformer)new ITransformer<Map.Entry<Object, Object>, Map.Entry<String, String>>(){

                public Map.Entry<String, String> transform(final Map.Entry<Object, Object> in) {
                    return new Map.Entry<String, String>(){

                        @Override
                        public String getKey() {
                            return (String)in.getKey();
                        }

                        @Override
                        public String getValue() {
                            return (String)in.getValue();
                        }

                        @Override
                        public String setValue(String value) {
                            return in.setValue(value);
                        }
                    };
                }
            });
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
            Iterators.addAll(this.entryIterator(), set);
            return set;
        }
    }
}

