/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource.impl.itemtxt;

import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.files.FileTools;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.kfacet.IFacet;
import de.xam.kfacet.KFacets;
import de.xam.ksource.ISource;
import de.xam.ksource.ISourceItem;
import de.xam.ksource.KSources;
import de.xam.ksource.impl.itemtxt.DataFileFormat;
import de.xam.ksource.impl.itemtxt.DataFileSource;
import de.xam.ksource.impl.itemtxt.ExternalFileFormat;
import de.xam.mybase.model.names.IdManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.xydra.base.XId;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class DataFileSourceItem
implements ISourceItem {
    static final Logger log = LoggerFactory.getLogger(DataFileSourceItem.class);
    private final XId id;
    private final DataFileSource source;

    private static DataFileFormat.ICreatePropertyAndRelations createPropertyAndRelations(final IItemSet myBase) {
        return new DataFileFormat.ICreatePropertyAndRelations(){

            @Override
            public void getOrCreatePropertyWithId(XId propId, IChangeData changeData) {
                IItem propItem = myBase.getItemById(propId);
                if (propItem == null) {
                    ItemSets.getOrCreateItemWithStringContent((IItemSet)myBase, (XId)propId, (String)propId.toString(), (IChangeData)changeData);
                }
            }

            @Override
            public void getOrCreateRelationWithId(XId relId, IChangeData changeData) {
                IItem relItem = myBase.getItemById(relId);
                if (relItem == null) {
                    ItemSets.getOrCreateItemWithStringContent((IItemSet)myBase, (XId)relId, (String)relId.toString(), (IChangeData)changeData);
                }
            }
        };
    }

    protected static boolean isItemHelperFile(File itemFile, File f) {
        String itemFileName = itemFile.toString();
        return f.getName().startsWith(itemFileName) && f.getName().length() > itemFileName.length();
    }

    static IItem readDataFromItemFileToMyBase(File f, XId id, IItemSet myBase) throws IOException {
        IChangeData changeData = ChangeDatas.createFileChangeData((File)f);
        try {
            return DataFileFormat.readDataFromItemFileToMyBase(f, id, DataFileSourceItem.createPropertyAndRelations(myBase), DataFileSourceItem.writeMyBase(myBase), changeData);
        }
        catch (AssertionError | Exception e) {
            throw new RuntimeException("failed while parsing " + f.getAbsolutePath(), (Throwable)e);
        }
    }

    public static XId toId(File itemFile) {
        assert (itemFile.getName().endsWith("item.txt"));
        String idStr = itemFile.getName().substring(0, itemFile.getName().length() - ".".length() - "item.txt".length());
        XId id = IdManager.toFastRawId((String)idStr);
        return id;
    }

    public static DataFileFormat.IWriteMyBase writeMyBase(final IItemSet myBase) {
        return new DataFileFormat.IWriteMyBase(){

            @Override
            public IItem getItemById(XId id) {
                return myBase.getItemById(id);
            }

            @Override
            public IItem getOrCreateItemWithId(XId id, String content, IChangeData changeData) {
                return ItemSets.getOrCreateItemWithStringContent((IItemSet)myBase, (XId)id, (String)content, (IChangeData)changeData);
            }
        };
    }

    public DataFileSourceItem(DataFileSource source, File f) {
        assert (source != null);
        this.source = source;
        this.id = DataFileSourceItem.toId(f);
    }

    public DataFileSourceItem(DataFileSource source, XId id) {
        assert (source != null);
        this.source = source;
        this.id = id;
    }

    private static String getExternalFormat(XId p) throws IOException {
        for (ISource source : KSources.sources()) {
            for (Map.Entry<XId, String> entry : source.shouldPersistInExternalFile().entrySet()) {
                if (!entry.getKey().equals((Object)p)) continue;
                return entry.getValue();
            }
        }
        for (IFacet facet : KFacets.facets()) {
            for (Map.Entry<Object, String> entry : facet.shouldPersistInExternalFile().entrySet()) {
                if (!((XId)entry.getKey()).equals((Object)p)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public XId getId() {
        return this.id;
    }

    public File getItemFile() {
        assert (this.source != null);
        assert (this.source.getRootDir() != null);
        File f = new File(this.source.getRootDir(), this.getLocalStringId() + "." + "item.txt");
        return f;
    }

    @Override
    public String getLocalStringId() {
        return this.id.toString();
    }

    private static Set<XId> propertiesHandledExternally() throws IOException {
        HashSet<XId> result = new HashSet<XId>();
        for (ISource source : KSources.sources()) {
            result.addAll(source.shouldPersistInExternalFile().keySet());
        }
        for (IFacet facet : KFacets.facets()) {
            result.addAll(facet.shouldPersistInExternalFile().keySet());
        }
        return result;
    }

    @Override
    public void readDataToMyBase(IItemSet itemSet) throws IOException {
        File f = this.getItemFile();
        assert (f.exists()) : "" + f.getAbsolutePath();
        assert (f.isFile());
        final IItem item = DataFileSourceItem.readDataFromItemFileToMyBase(f, this.getId(), itemSet);
        FileTools.process((File)this.source.getRootDir(), (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return DataFileSourceItem.isItemHelperFile(DataFileSourceItem.this.getItemFile(), pathname);
            }
        }, (FileTools.IFileProcessor)new FileTools.IFileProcessor(){

            public void process(File f) throws IOException {
                DataFileSourceItem.this.readHelperFile(f, item);
            }
        }, null, (boolean)true);
    }

    protected void readHelperFile(File f, IItem item) throws IOException {
        String[] parts = f.getName().split("[.]");
        assert (parts.length == 3) : "itemId.propertyId.extension";
        XId p = IdManager.toFastRawId((String)parts[1]);
        String extension = parts[2];
        if (extension.equals("txt")) {
            String s = FileUtils.readFileToString((File)f, (String)"utf-8");
            item.setAttribute(p, (XValue)XV.toValue((String)s));
        } else {
            byte[] bytes = FileUtils.readFileToByteArray((File)f);
            item.setAttribute(p, (XValue)XV.toValue((byte[])bytes));
        }
    }

    @Override
    public void writeBackToSource(IItemSet itemSet) throws IOException, UnsupportedOperationException {
        DataFileFormat.write(DataFileSourceItem.writeMyBase(itemSet), this.getId(), DataFileSourceItem.propertiesHandledExternally(), this.getItemFile());
        XId itemId = this.getId();
        IItem item = itemSet.getItemById(itemId);
        assert (item != null);
        for (XId p : DataFileSourceItem.propertiesHandledExternally()) {
            XValue value = item.getAttribute(p);
            String format = DataFileSourceItem.getExternalFormat(p);
            ExternalFileFormat.writeSpecialPropertyValueToFile(this.source.getRootDir(), itemId, p, value, format);
        }
    }
}

