/*
 * Decompiled with CFR 0.152.
 */
package de.xam.resourceloader;

import de.xam.resourceloader.ResourceLoaderTool;
import de.xam.resourceloader.ResourceNotFoundException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);
    private String search;
    private String replace;
    private File[] baseDirs = new File[0];

    public void addBaseDirs(Collection<String> baseDirPaths) {
        ArrayList<File> baseDirs = new ArrayList<File>();
        for (File f : this.baseDirs) {
            baseDirs.add(f);
        }
        for (String s : baseDirPaths) {
            File f = new File(s);
            if (f.exists() && f.isDirectory()) {
                baseDirs.add(f);
                continue;
            }
            log.warn("Path '" + f.getAbsolutePath() + "' is not an exising directory, ignored for resource loading.");
        }
        this.baseDirs = baseDirs.toArray(new File[0]);
        if (log.isTraceEnabled()) {
            log.trace("Base dirs = " + Arrays.toString(this.baseDirs));
        }
    }

    public void setAutoPathSearchAndReplace(String search, String replace) {
        this.search = search;
        this.replace = replace;
        if (log.isTraceEnabled()) {
            log.trace("Search '" + search + "' Replace '" + replace + "' defined.");
        }
    }

    private InputStream inputStreamFromFileSystemOrClassPath(String name) {
        InputStream in = ResourceLoaderTool.inputStreamFromFileSystem(name, this.baseDirs);
        if (in != null) {
            return in;
        }
        in = ResourceLoaderTool.inputStreamFromClassLoader(name);
        if (in != null) {
            return in;
        }
        return null;
    }

    public InputStream getResourceAsStream(String name) throws ResourceNotFoundException {
        InputStream in = this.inputStreamFromFileSystemOrClassPath(name);
        if (in != null) {
            return in;
        }
        if (this.autoSearchAndReplaceIsActive()) {
            String renamed = name.replace(this.search, this.replace);
            in = this.inputStreamFromFileSystemOrClassPath(renamed);
            if (in != null) {
                return in;
            }
            throw new ResourceNotFoundException("Resource found neither as '" + name + "', nor '" + renamed + "' (automatic renaming search/replace) is active.");
        }
        throw new ResourceNotFoundException("Resource not found as '" + name + "', no automatic renaming(search/replace) active.");
    }

    private boolean autoSearchAndReplaceIsActive() {
        return this.search != null && this.replace != null;
    }
}

