/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.csv.ICell;
import org.xydra.csv.IReadableRow;
import org.xydra.csv.impl.memory.AbstractReadableRow;
import org.xydra.csv.impl.memory.Cell;

public class SingleRow
extends AbstractReadableRow
implements IReadableRow {
    private static final long serialVersionUID = -7970004628196813272L;
    private final Map<String, ICell> map = new HashMap<String, ICell>();

    public SingleRow(String key) {
        super(key);
    }

    public SingleRow(String key, String[][] arrayOfPairs) {
        this(key);
        for (String[] pair : arrayOfPairs) {
            assert (pair.length == 2);
            this.map.put(pair[0], new Cell(pair[1]));
        }
    }

    public SingleRow(String key, Map<String, String> map) {
        this(key);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.map.put(entry.getKey(), new Cell(entry.getValue()));
        }
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.map.keySet();
    }

    @Override
    public Iterator<ICell> iterator() {
        return this.map.values().iterator();
    }

    protected void removeValue(String colName) {
        this.map.remove(colName);
    }

    @Override
    public ICell getOrCreateCell(String columnName, boolean create) {
        ICell cell = this.map.get(columnName);
        if (cell == null && create) {
            cell = new Cell();
            this.map.put(columnName, cell);
        }
        return cell;
    }

    @Override
    public Set<Map.Entry<String, ICell>> entrySet() {
        return this.map.entrySet();
    }

    public void setValue(String columnName, String value, boolean initial) {
        if (value != null) {
            ICell cell = this.getOrCreateCell(columnName, true);
            try {
                cell.setValue(value, initial);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not set value in column (" + columnName + ")", e);
            }
        }
    }
}

