/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv.impl.memory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.csv.ExcelLimitException;
import org.xydra.csv.ICell;
import org.xydra.csv.IReadableRow;
import org.xydra.csv.IRow;
import org.xydra.csv.ISparseTable;
import org.xydra.csv.impl.memory.AbstractRow;
import org.xydra.csv.impl.memory.Cell;
import org.xydra.csv.impl.memory.Shared;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Row
extends AbstractRow
implements IRow {
    private static final Logger log = LoggerFactory.getLogger(Row.class);
    private static final long serialVersionUID = -1859613946021005526L;
    private final HashMap<String, ICell> map = new HashMap();
    private final ISparseTable table;

    Row(String key, ISparseTable table) {
        super(key);
        assert (table != null);
        this.table = table;
    }

    @Override
    public void aggregate(IReadableRow row, String[] keyColumnNames) {
        assert (row != null);
        for (String colName : this.table.getColumnNames()) {
            if (colName.equals("ROW") || !this.contains(keyColumnNames, colName)) continue;
            String thisValue = this.getValue(colName);
            String otherValue = row.getValue(colName);
            if (otherValue == null || otherValue.equals("")) continue;
            try {
                long thisLong = thisValue == null ? 0L : Long.parseLong(thisValue);
                long otherLong = Long.parseLong(otherValue);
                long sum = thisLong + otherLong;
                if (sum == 0L) {
                    this.removeValue(colName);
                    continue;
                }
                this.setValue(colName, "" + sum);
            }
            catch (NumberFormatException e) {
                if (otherValue.equals("")) continue;
                if (thisValue == null || thisValue.equals("")) {
                    this.setValue(colName, otherValue);
                    continue;
                }
                if (thisValue.equals(otherValue) || !this.table.getParamAggregateStrings() || Shared.contains(thisValue, otherValue)) continue;
                String concat = thisValue + "|" + otherValue;
                this.setValue(colName, concat);
            }
        }
    }

    @Override
    public Set<Map.Entry<String, ICell>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.map.keySet();
    }

    @Override
    public ICell getOrCreateCell(String column, boolean create) {
        ICell c = this.map.get(column);
        if (c == null && create) {
            if (this.table.getColumnNames().size() == 255) {
                log.warn("Cannot add the 255th column - that is Excels limit");
                if (this.table.getParamRestrictToExcelSize()) {
                    throw new ExcelLimitException("Column limit reached");
                }
            }
            c = new Cell();
            this.map.put(column, c);
            this.table.addColumnName(column);
        }
        return c;
    }

    @Override
    public String getValue(String columnName) {
        ICell cell = this.getOrCreateCell(columnName, false);
        return cell == null ? "null" : cell.getValue();
    }

    @Override
    public Iterator<ICell> iterator() {
        return this.map.values().iterator();
    }

    @Override
    protected void removeValue(String colName) {
        this.map.remove(colName);
    }
}

