/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.csv;

public interface IAggregationFunction {
    public String aggregate(double var1, double var3);

    public String aggregate(long var1, long var3);

    public String aggregate(String var1, String var2);

    public static class SUM
    implements IAggregationFunction {
        @Override
        public String aggregate(double a, double b) {
            return "" + a + b;
        }

        @Override
        public String aggregate(long a, long b) {
            return "" + a + b;
        }

        @Override
        public String aggregate(String a, String b) {
            return "##";
        }
    }

    public static class AVERAGE
    implements IAggregationFunction {
        @Override
        public String aggregate(double a, double b) {
            return "" + (a + b) / 2.0;
        }

        @Override
        public String aggregate(long a, long b) {
            return "" + (a + b) / 2L;
        }

        @Override
        public String aggregate(String a, String b) {
            return "##";
        }
    }
}

