/*
 * Decompiled with CFR 0.152.
 */
package de.xam.tupleinf.impl;

import de.xam.tupleinf.IInverseTransitiveTupleIndex;
import de.xam.tupleinf.ITupleSink;
import de.xam.tupleinf.InfLayerRead;
import de.xam.tupleinf.impl.ITTI_Base;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.MapSetIndex;
import org.xydra.index.impl.SmallEntrySetFactory;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.EqualsConstraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ITTI_Fast2<T>
extends ITTI_Base<T>
implements IInverseTransitiveTupleIndex<T> {
    private static final Logger log = LoggerFactory.getLogger(ITTI_Fast2.class);
    protected final MapSetIndex<T, T> baseTuples;
    protected final MapSetIndex<T, T> infdTuples;
    private ITupleSink<T> optionalTupleSink;

    public ITTI_Fast2(T p) {
        this(p, false);
    }

    public ITTI_Fast2(T p, boolean concurrent) {
        super(p, concurrent);
        this.baseTuples = new MapSetIndex((Factory)new FastEntrySetFactory(concurrent), concurrent);
        this.infdTuples = new MapSetIndex((Factory)new FastEntrySetFactory(concurrent), concurrent);
        this.checkAssertions();
        assert (this.isPrimary());
    }

    @Override
    protected void do__clearBase() {
        this.baseTuples.clear();
        this.do__markInferenceAsDirty();
    }

    @Override
    protected void do__clearInfd() {
        this.infdTuples.clear();
    }

    @Override
    protected void do__contentToString(StringBuilder buf) {
        buf.append("---baseTuples---\n");
        buf.append(this.baseTuples.toString() + "\n");
        buf.append("---infTuples---\n");
        buf.append(this.infdTuples.toString() + "\n");
    }

    @Override
    protected void do__dumpContent() {
        if (!this.baseTuples.isEmpty()) {
            log.info("--- BaseTuples");
            this.baseTuples.dump();
        }
        if (!this.infdTuples.isEmpty()) {
            log.info("--- InfTuples");
            this.infdTuples.dump();
        }
    }

    @Override
    protected void primary__inference() {
        if (log.isDebugEnabled()) {
            log.debug("doInference");
        }
        this.do__markInferenceAsComplete();
        Iterator<KeyEntryTuple<T, T>> baseOrInfdIt_AB = this.primary__tupleIterator(this.ANY, this.ANY, InfLayerRead.Both);
        while (baseOrInfdIt_AB.hasNext()) {
            KeyEntryTuple<T, T> baseOrInfdTuple = baseOrInfdIt_AB.next();
            this.primary__inferFrom(baseOrInfdTuple.getFirst(), baseOrInfdTuple.getSecond());
        }
        assert (this.isInferenceComplete());
    }

    protected final boolean primary__inferFrom(T a, T b) {
        assert (this.isPrimary());
        boolean newTuples = false;
        return newTuples |= this.primary__inferTransitiveFrom(a, b);
    }

    private boolean primary__inferSymmericFrom(T a, T b) {
        if (!this.primary__isSymmetric()) {
            return false;
        }
        if (this.baseTuples.contains(b, a)) {
            return false;
        }
        return this.infdTuples.index(b, a);
    }

    private boolean primary__inferTransitiveFrom(T a, T b) {
        if (!this.primary__isTransitive()) {
            return false;
        }
        boolean inferredNew = false;
        MapSetIndex checkTuples = new MapSetIndex((Factory)new SmallEntrySetFactory());
        checkTuples.index(a, b);
        do {
            MapSetIndex checkNewTuples = new MapSetIndex((Factory)new SmallEntrySetFactory());
            for (Map.Entry e : checkTuples.getEntries()) {
                for (Object g : (IEntrySet)e.getValue()) {
                    Object f = e.getKey();
                    this.primary_inferTransitive_right_from(f, g, checkNewTuples);
                    this.primary_inferTransitive_left_from(f, g, checkNewTuples);
                }
            }
            checkTuples = checkNewTuples;
            inferredNew |= checkTuples.isEmpty();
        } while (!checkTuples.isEmpty());
        return inferredNew;
    }

    private boolean primary_inferTransitive_left_from(T a, T b, MapSetIndex<T, T> newTuples) {
        HashSet Wb;
        boolean trace = log.isTraceEnabled();
        HashSet<T> Vb = new HashSet<T>();
        Vb.add(a);
        do {
            Wb = new HashSet();
            for (Object v : Vb) {
                EqualsConstraint cV = new EqualsConstraint(v);
                Iterator Wv_it = this.baseTuples.tupleIterator(this.ANY, (Constraint)cV);
                if (trace && Wv_it.hasNext()) {
                    log.trace("   BASE: Infer from (?w," + v + ")(" + v + "," + b + "), ?w=" + Iterators.toList((Iterator)this.baseTuples.tupleIterator(this.ANY, (Constraint)cV)));
                }
                this.primary__inferTransitiveStep_left(b, v, Wv_it, Wb, newTuples);
                Wv_it = this.infdTuples.tupleIterator(this.ANY, (Constraint)cV);
                if (trace && Wv_it.hasNext()) {
                    log.trace("   INFD: Infer from (?w," + v + ")(" + v + "," + b + "), ?w=" + Iterators.toList((Iterator)this.infdTuples.tupleIterator(this.ANY, (Constraint)cV)));
                }
                this.primary__inferTransitiveStep_left(b, v, Wv_it, Wb, newTuples);
            }
        } while (!(Vb = Wb).isEmpty());
        return !Vb.isEmpty();
    }

    private boolean primary_inferTransitive_right_from(T a, T b, MapSetIndex<T, T> newTuples) {
        HashSet aY;
        boolean trace = log.isTraceEnabled();
        IEntrySet base_aY = this.baseTuples.lookup(a);
        IEntrySet infd_aY = null;
        if (trace) {
            log.trace("(" + a + "," + b + ")  infer with   base(" + a + ",?) = " + base_aY + ";   inf(" + a + ",?) = " + infd_aY + "");
        }
        HashSet<T> aX = new HashSet<T>();
        aX.add(b);
        do {
            if (trace) {
                log.trace("    ---- aX = " + aX);
            }
            if (infd_aY == null) {
                infd_aY = this.infdTuples.lookup(a);
            }
            aY = new HashSet();
            for (Object x : aX) {
                IEntrySet base_xY = this.baseTuples.lookup(x);
                if (trace && base_xY != null) {
                    log.trace("   BASE: Infer from (" + a + "," + x + ")(" + x + ",?) =" + base_xY + " into aY=" + aY);
                }
                this.primary__inferTransitiveStep_right(a, x, base_xY, base_aY, infd_aY, aY, newTuples);
                IEntrySet infd_xY = this.infdTuples.lookup(x);
                if (trace && infd_xY != null) {
                    log.trace("   INFD: Infer from (" + a + "," + x + ")(" + x + ",?) =" + infd_xY + " into aY=" + aY);
                }
                this.primary__inferTransitiveStep_right(a, x, infd_xY, base_aY, infd_aY, aY, newTuples);
            }
        } while (!(aX = aY).isEmpty());
        return !aX.isEmpty();
    }

    private void primary__inferTransitiveStep_left(T b, T v, Iterator<KeyEntryTuple<T, T>> wv_it, Set<T> wSet, MapSetIndex<T, T> newTuples) {
        while (wv_it.hasNext()) {
            KeyEntryTuple<T, T> wv = wv_it.next();
            assert (wv.getSecond().equals(v)) : "second=" + wv.getSecond() + " v=" + v;
            Object w = wv.getFirst();
            if (this.baseTuples.contains(w, b)) continue;
            boolean notYetInInf = this.infdTuples.index(w, b);
            if (notYetInInf) {
                log.trace("      +New (" + w + "," + b + ")");
                wSet.add(w);
                newTuples.index(w, b);
                if (this.optionalTupleSink == null) continue;
                this.optionalTupleSink.index(w, b);
                continue;
            }
            log.trace("      +old (" + w + "," + b + ")");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ITTI_Fast2)) {
            return false;
        }
        ITTI_Fast2 other = (ITTI_Fast2)obj;
        return this.p.equals(other.p) && this.flagSymmetric == other.flagSymmetric && this.flagTransitive == other.flagTransitive && this.isPrimary() == other.isPrimary() && this.baseTuples.equals(other.baseTuples);
    }

    public int hashCode() {
        return this.p.hashCode();
    }

    private void primary__inferTransitiveStep_right(T a, T x, IEntrySet<T> xY, IEntrySet<T> base_aY, IEntrySet<T> infd_aY, Set<T> aY_target, MapSetIndex<T, T> newTuples) {
        if (xY == null) {
            return;
        }
        boolean trace = log.isTraceEnabled();
        for (Object y : xY) {
            if (base_aY == null || !base_aY.contains(y)) {
                boolean notYetInInf;
                if (infd_aY == null) {
                    this.infdTuples.index(a, y);
                    notYetInInf = true;
                } else {
                    notYetInInf = infd_aY.index(y);
                }
                if (!notYetInInf) continue;
                aY_target.add(y);
                newTuples.index(a, y);
                if (this.optionalTupleSink != null) {
                    this.optionalTupleSink.index(a, y);
                }
                if (!trace) continue;
                log.trace("      +New (" + a + "," + y + ")");
                continue;
            }
            if (!trace) continue;
            log.trace("      -Old (" + a + "," + y + ")");
        }
    }

    @Override
    public Iterator<KeyEntryTuple<T, T>> primary__baseTupleIterator() {
        return this.baseTuples.tupleIterator(this.ANY, this.ANY);
    }

    @Override
    protected void primary__clearAll() {
        this.baseTuples.clear();
        this.infdTuples.clear();
    }

    @Override
    protected boolean primary__contains(Constraint<T> cA, Constraint<T> cB, InfLayerRead infLayer) {
        this.primary__ensureInference();
        return this.baseTuples.contains(cA, cB) || this.infdTuples.contains(cA, cB);
    }

    @Override
    protected boolean primary__contains(T a, T b, InfLayerRead infLayer) {
        this.primary__ensureInference();
        return this.baseTuples.contains(a, b) || this.infdTuples.contains(a, b);
    }

    @Override
    protected boolean primary__deIndex(T a, T b) {
        this.do__markInferenceAsDirty();
        return this.baseTuples.deIndex(a, b);
    }

    @Override
    protected boolean primary__index(T a, T b) {
        boolean added = this.baseTuples.index(a, b);
        if (!added) {
            return false;
        }
        boolean infRemoved = this.infdTuples.deIndex(a, b);
        if (infRemoved) {
            return true;
        }
        if (this.primary__isTransitive()) {
            if (this.isInferenceComplete()) {
                if (log.isDebugEnabled()) {
                    log.debug("incremental inference");
                }
                this.primary__inferFrom(a, b);
            } else assert (!this.isInferenceComplete()) : "dirty flag is set anyway";
        }
        return added;
    }

    @Override
    protected boolean primary__isEmpty() {
        return this.baseTuples.isEmpty() && this.infdTuples.isEmpty();
    }

    @Override
    protected Iterator<T> primary__query_aX_project_X(Constraint<T> cA, InfLayerRead infLayer) {
        this.primary__ensureInference();
        ClosableIterator aX_it1 = this.baseTuples.constraintIterator(cA);
        ClosableIterator aX_it2 = this.infdTuples.constraintIterator(cA);
        return Iterators.concat((Iterator)aX_it1, (Iterator)aX_it2);
    }

    @Override
    public Iterator<KeyEntryTuple<T, T>> primary__tupleIterator(Constraint<T> cA, Constraint<T> cB, InfLayerRead infLayer) {
        this.checkAssertions();
        assert (this.isPrimary());
        if (log.isDebugEnabled()) {
            log.debug(this.getP() + ".(" + cA + ", " + cB + ")");
        }
        this.primary__ensureInference();
        return this.do__tupleIterator(cA, cB);
    }

    @Override
    public Iterator<KeyEntryTuple<T, T>> primary__tuples(InfLayerRead infLayer) {
        this.checkAssertions();
        assert (this.isPrimary());
        if (log.isDebugEnabled()) {
            log.debug(this.getP() + ".()");
        }
        this.primary__ensureInference();
        return this.do__tuples();
    }

    protected Iterator<KeyEntryTuple<T, T>> do__tuples() {
        ClosableIterator result = Iterators.concat((Iterator)this.baseTuples.tuples(), (Iterator)this.infdTuples.tuples());
        return result;
    }

    @Override
    protected Iterator<KeyEntryTuple<T, T>> do__tupleIterator(Constraint<T> cA, Constraint<T> cB) {
        ClosableIterator result = Iterators.concat((Iterator)this.baseTuples.tupleIterator(cA, cB), (Iterator)this.infdTuples.tupleIterator(cA, cB));
        return result;
    }

    @Override
    public boolean indexInfd(T a, T b) {
        if (this.baseTuples.contains(a, b)) {
            return false;
        }
        boolean added = this.infdTuples.index(a, b);
        if (added) {
            this.primary__inferFrom(a, b);
        }
        return added;
    }

    @Override
    public boolean deIndexInfd(T a, T b) {
        return this.infdTuples.deIndex(a, b);
    }

    @Override
    public void setInfdTupleSink(ITupleSink<T> tupleSink) {
        this.optionalTupleSink = tupleSink;
    }
}

