/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.lang.reflect.Array;
import java.util.LinkedHashSet;
import java.util.Map;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.data.MapEntry;
import org.fest.assertions.error.ShouldBeEmpty;
import org.fest.assertions.error.ShouldBeNullOrEmpty;
import org.fest.assertions.error.ShouldContain;
import org.fest.assertions.error.ShouldContainKey;
import org.fest.assertions.error.ShouldContainValue;
import org.fest.assertions.error.ShouldHaveSameSizeAs;
import org.fest.assertions.error.ShouldHaveSize;
import org.fest.assertions.error.ShouldNotBeEmpty;
import org.fest.assertions.error.ShouldNotContain;
import org.fest.assertions.error.ShouldNotContainKey;
import org.fest.assertions.error.ShouldNotContainValue;
import org.fest.assertions.internal.CommonErrors;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Objects;
import org.fest.util.Collections;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maps {
    private static Maps INSTANCE = new Maps();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Maps instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Maps() {
    }

    public void assertNullOrEmpty(AssertionInfo info, Map<?, ?> actual) {
        if (actual == null || actual.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
    }

    public void assertEmpty(AssertionInfo info, Map<?, ?> actual) {
        this.assertNotNull(info, actual);
        if (actual.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertNotEmpty(AssertionInfo info, Map<?, ?> actual) {
        this.assertNotNull(info, actual);
        if (!actual.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
    }

    public void assertHasSize(AssertionInfo info, Map<?, ?> actual, int expectedSize) {
        this.assertNotNull(info, actual);
        int sizeOfActual = actual.size();
        if (sizeOfActual == expectedSize) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSize.shouldHaveSize(actual, sizeOfActual, expectedSize));
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map, Iterable<?> other) {
        int sizeOfOther;
        this.assertNotNull(info, map);
        if (other == null) {
            throw new NullPointerException("The iterable to look for should not be null");
        }
        int sizeOfActual = map.size();
        if (sizeOfActual == (sizeOfOther = Collections.sizeOf(other))) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(map, sizeOfActual, sizeOfOther));
    }

    public void assertHasSameSizeAs(AssertionInfo info, Map<?, ?> map, Object[] other) {
        int sizeOfOther;
        this.assertNotNull(info, map);
        if (other == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
        int sizeOfActual = map.size();
        if (sizeOfActual == (sizeOfOther = Array.getLength(other))) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(map, sizeOfActual, sizeOfOther));
    }

    public void assertContains(AssertionInfo info, Map<?, ?> actual, MapEntry[] entries) {
        this.isNotEmptyOrNull(entries);
        this.assertNotNull(info, actual);
        LinkedHashSet<MapEntry> notFound = new LinkedHashSet<MapEntry>();
        for (MapEntry entry : entries) {
            if (this.containsEntry(actual, entry)) continue;
            notFound.add(entry);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContain.shouldContain(actual, entries, notFound));
    }

    public void assertDoesNotContain(AssertionInfo info, Map<?, ?> actual, MapEntry[] entries) {
        this.isNotEmptyOrNull(entries);
        this.assertNotNull(info, actual);
        LinkedHashSet<MapEntry> found = new LinkedHashSet<MapEntry>();
        for (MapEntry entry : entries) {
            if (!this.containsEntry(actual, entry)) continue;
            found.add(entry);
        }
        if (found.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, entries, found));
    }

    public <K, V> void assertContainsKey(AssertionInfo info, Map<K, V> actual, K key) {
        this.assertNotNull(info, actual);
        if (actual.containsKey(key)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainKey.shouldContainKey(actual, key));
    }

    public <K, V> void assertDoesNotContainKey(AssertionInfo info, Map<K, V> actual, K key) {
        this.assertNotNull(info, actual);
        if (!actual.containsKey(key)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainKey.shouldNotContainKey(actual, key));
    }

    public <K, V> void assertContainsValue(AssertionInfo info, Map<K, V> actual, V value) {
        this.assertNotNull(info, actual);
        if (actual.containsValue(value)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainValue.shouldContainValue(actual, value));
    }

    public <K, V> void assertDoesNotContainValue(AssertionInfo info, Map<K, V> actual, V value) {
        this.assertNotNull(info, actual);
        if (!actual.containsValue(value)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainValue.shouldNotContainValue(actual, value));
    }

    private void isNotEmptyOrNull(MapEntry[] entries) {
        if (entries == null) {
            throw new NullPointerException("The array of entries to look for should not be null");
        }
        if (entries.length == 0) {
            throw new IllegalArgumentException("The array of entries to look for should not be empty");
        }
    }

    private boolean containsEntry(Map<?, ?> actual, MapEntry entry) {
        if (entry == null) {
            throw new NullPointerException("Entries to look for should not be null");
        }
        if (!actual.containsKey(entry.key)) {
            return false;
        }
        return org.fest.util.Objects.areEqual(actual.get(entry.key), (Object)entry.value);
    }

    private void assertNotNull(AssertionInfo info, Map<?, ?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

