/*
 * Decompiled with CFR 0.152.
 */
package de.xam.texthtml.text;

import com.google.common.base.Joiner;
import de.xam.texthtml.text.TextTool;
import de.xam.texthtml.text.Unicodes;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.xydra.core.util.RegExUtil;
import org.xydra.index.impl.IntegerRangeIndex;

public class CamelCase {
    @Deprecated
    public static final Pattern pattern_CAMELCASE_v1 = Pattern.compile("(?U)\\b[\\w&&[^\\p{Digit}_]]+(?:[\\w&&[^\\p{javaUpperCase}]]+[\\w&&[^\\p{javaLowerCase}]]+)+[\\w&&[^_]]+\\b");
    public static final Pattern pattern_CAMELCASE = Pattern.compile(RegExUtil.unicode() + RegExUtil.inWordBoundary((String)"(?!_)(?!.*__)([\\p{javaUpperCase}]+[\\p{javaLowerCase}]+(_?([\\p{javaUpperCase}]+[\\p{javaLowerCase}]*|[0-9]+)|_[\\p{javaLowerCase}]+){1,5}|[\\p{javaUpperCase}]+[\\p{javaLowerCase}]+(_?([\\p{javaUpperCase}]+[\\p{javaLowerCase}]+|[\\p{javaUpperCase}]+)|_[\\p{javaLowerCase}]+)+|([\\p{javaUpperCase}]+[_\\p{javaLowerCase}]*)+((19|20)[0-9]{2})[\\p{javaUpperCase}_\\p{javaLowerCase}]*)(?<!_)"));

    public static boolean isCamelCase(String t) {
        return pattern_CAMELCASE.matcher(t).matches();
    }

    public static String[] splitCamelCaseAndDigits(final String token) {
        final ArrayList fragments = new ArrayList();
        CamelCase.splitCamelCaseAndDigits(token, 0, token.length(), new IntegerRangeIndex.ISplitHandler(){

            public void onToken(int startInclusive, int endExclusive) {
                fragments.add(token.substring(startInclusive, endExclusive));
            }

            public void onSeparator(int startInclusive, int endExclusive) {
            }

            public void onDone() {
            }
        });
        return fragments.toArray(new String[fragments.size()]);
    }

    public static void splitCamelCaseAndDigits(String s, int startInclusive, int endExclusive, IntegerRangeIndex.ISplitHandler splitHandler) {
        int codepoint;
        Unicodes.KindOfCharacter mode = Unicodes.KindOfCharacter.None;
        assert (s != null);
        int length = endExclusive - startInclusive;
        if (length == 0) {
            return;
        }
        int fragmentStart = startInclusive;
        for (int offset = startInclusive; offset < endExclusive; offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            Unicodes.KindOfCharacter currentMode = Unicodes.getKindOfCharacter(codepoint);
            if (currentMode == mode) continue;
            boolean split = false;
            if (currentMode == Unicodes.KindOfCharacter.Digit) {
                split = true;
            } else if (currentMode == Unicodes.KindOfCharacter.Uppercase) {
                split = true;
            }
            if (split && offset > fragmentStart) {
                splitHandler.onToken(fragmentStart, offset);
                fragmentStart = offset;
            }
            mode = currentMode;
        }
        if (fragmentStart < endExclusive) {
            splitHandler.onToken(fragmentStart, endExclusive);
        }
    }

    public static String convertTo__Word_word_word(String camelCased) {
        String[] words = CamelCase.splitCamelCaseAndDigits(camelCased);
        return CamelCase.convertTo__Word_word_word(words);
    }

    public static String convertTo__Word_word_word(String[] words) {
        if (words.length == 0) {
            return "";
        }
        Object[] converted = new String[words.length];
        converted[0] = CamelCase.capitalize(words[0]);
        if (words.length > 1) {
            for (int i = 1; i < words.length; ++i) {
                converted[i] = TextTool.lowercase(words[i]);
            }
        }
        return Joiner.on((String)" ").join(converted);
    }

    private static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int first = s.codePointAt(0);
        int firstUpper = Character.toUpperCase(first);
        if (s.length() == 1) {
            return new String(Character.toChars(firstUpper));
        }
        StringBuilder b = new StringBuilder();
        b.append(Character.toChars(firstUpper));
        b.append(s.substring(Character.charCount(first)));
        return b.toString();
    }

    private static String capitalizeFully(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int first = s.codePointAt(0);
        int firstUpper = Character.toUpperCase(first);
        if (s.length() == 1) {
            return new String(Character.toChars(firstUpper));
        }
        StringBuilder b = new StringBuilder();
        b.append(Character.toChars(firstUpper));
        b.append(s.substring(Character.charCount(first)).toLowerCase());
        return b.toString();
    }

    public static String convertTo__Word_Word_Word(String camelCased) {
        String[] words = CamelCase.splitCamelCaseAndDigits(camelCased);
        return CamelCase.convertTo__Word_Word_Word(words);
    }

    public static String convertTo__Word_Word_Word(String[] words) {
        if (words.length == 0) {
            return "";
        }
        Object[] converted = new String[words.length];
        for (int i = 0; i < words.length; ++i) {
            converted[i] = CamelCase.capitalizeFully(words[i]);
        }
        return Joiner.on((String)" ").join(converted);
    }

    public static String convertTo__word_word_word(String camelCased) {
        Object[] words = CamelCase.splitCamelCaseAndDigits(camelCased);
        if (words.length > 0) {
            for (int i = 0; i < words.length; ++i) {
                words[i] = TextTool.lowercase((String)words[i]);
            }
        }
        return Joiner.on((String)" ").join(words);
    }

    public static String convertTo__WordWordWord(String anyText) {
        Object[] parts = anyText.split("[ \t\n-]");
        if (parts.length > 0) {
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = CamelCase.capitalize((String)parts[i]);
            }
        }
        return Joiner.on((String)"").join(parts);
    }
}

