/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.SpyAnnotationEngine;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldInitializationReport;
import org.mockito.internal.util.reflection.FieldInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GwtSpyAnnotationEngine
extends SpyAnnotationEngine {
    GwtSpyAnnotationEngine() {
    }

    public void process(Class<?> context, Object testInstance) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            this.assertNoIncompatibleAnnotations(Spy.class, field, com.googlecode.gwt.test.Mock.class, Mock.class, MockitoAnnotations.Mock.class, Captor.class);
            Object instance = null;
            try {
                FieldInitializationReport report = new FieldInitializer(testInstance, field).initialize();
                instance = report.fieldInstance();
            }
            catch (MockitoException e) {
                new Reporter().cannotInitializeForSpyAnnotation(field.getName(), (Exception)((Object)e));
            }
            try {
                if (new MockUtil().isMock(instance)) {
                    Mockito.reset((Object[])new Object[]{instance});
                    continue;
                }
                field.setAccessible(true);
                field.set(testInstance, Mockito.mock(instance.getClass(), (MockSettings)Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
            }
            catch (IllegalAccessException e) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), (Throwable)e);
            }
        }
    }

    void assertNoIncompatibleAnnotations(Class<? extends Annotation> annotation, Field field, Class<? extends Annotation> ... undesiredAnnotations) {
        for (Class<? extends Annotation> u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            new Reporter().unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
        }
    }
}

