/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.web;

import com.googlecode.gwt.test.web.MockServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.StringAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletConfig
implements ServletConfig {
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private final ServletContext servletContext;
    private final String servletName;

    public MockServletConfig() {
        this(null, "");
    }

    public MockServletConfig(ServletContext servletContext) {
        this(servletContext, "");
    }

    public MockServletConfig(ServletContext servletContext, String servletName) {
        this.servletContext = servletContext != null ? servletContext : new MockServletContext();
        this.servletName = servletName;
    }

    public MockServletConfig(String servletName) {
        this(null, servletName);
    }

    public void addInitParameter(String name, String value) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        this.initParameters.put(name, value);
    }

    public String getInitParameter(String name) {
        ((StringAssert)Assertions.assertThat((String)name).as("Parameter name must not be null")).isNotNull();
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletName() {
        return this.servletName;
    }
}

