/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.utils;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.googlecode.gwt.test.utils.GwtDomUtils;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetUtils {
    public static boolean assertListBoxDataMatch(ListBox listBox, String[] content) {
        int contentSize = content.length;
        if (contentSize != listBox.getItemCount()) {
            return false;
        }
        for (int i = 0; i < contentSize; ++i) {
            if (content[i].equals(listBox.getItemText(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends EventHandler> List<T> getHandlers(Widget widget, DomEvent.Type<T> eventType) {
        HandlerManager handlerManager = (HandlerManager)GwtReflectionUtils.getPrivateFieldValue((Object)widget, "handlerManager");
        Object handlerRegistry = GwtReflectionUtils.getPrivateFieldValue((Object)handlerManager, "eventBus");
        Map map = (Map)GwtReflectionUtils.getPrivateFieldValue(handlerRegistry, "map");
        Map eventHandlerMap = (Map)map.get(eventType);
        ArrayList result = new ArrayList();
        if (eventHandlerMap != null) {
            for (List eventHandlerList : eventHandlerMap.values()) {
                result.addAll(eventHandlerList);
            }
        }
        return result;
    }

    public static int getIndexInListBox(ListBox listBox, String regex) {
        int selectedIndex = -1;
        Pattern p = Pattern.compile(regex);
        int i = 0;
        while (i < listBox.getItemCount() && selectedIndex == -1) {
            String itemText = listBox.getItemText(i);
            Matcher m = p.matcher(itemText);
            if (m.matches() || regex.equals(itemText)) {
                selectedIndex = i;
                continue;
            }
            ++i;
        }
        return selectedIndex;
    }

    public static String getListBoxContentToString(ListBox listBox) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listBox.getItemCount(); ++i) {
            sb.append(listBox.getItemText(i)).append(" | ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static List<MenuItem> getMenuItems(MenuBar menuBar) {
        return (List)GwtReflectionUtils.getPrivateFieldValue((Object)menuBar, "items");
    }

    public static List<MenuItem> getMenuItems(SuggestBox suggestBox) {
        SuggestBox.SuggestionDisplay display = (SuggestBox.SuggestionDisplay)GwtReflectionUtils.getPrivateFieldValue((Object)suggestBox, "display");
        MenuBar suggestionMenu = (MenuBar)GwtReflectionUtils.getPrivateFieldValue((Object)display, "suggestionMenu");
        return WidgetUtils.getMenuItems(suggestionMenu);
    }

    public static boolean hasStyle(UIObject object, String styleName) {
        return object.getStyleName().contains(styleName);
    }

    public static boolean isWidgetVisible(UIObject object) {
        if (object == null) {
            return false;
        }
        if (object instanceof RootPanel) {
            return true;
        }
        if (object instanceof PopupPanel) {
            PopupPanel popup = (PopupPanel)object;
            return popup.isShowing();
        }
        return GwtDomUtils.isVisible((Element)object.getElement());
    }

    public static void setCheckBoxValueSilent(CheckBox checkBox, boolean newValue) {
        InputElement inputElem = (InputElement)GwtReflectionUtils.getPrivateFieldValue((Object)checkBox, "inputElem");
        inputElem.setChecked(newValue);
        inputElem.setDefaultChecked(newValue);
    }

    private WidgetUtils() {
    }
}

