/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.uibinder.widget;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.googlecode.gwt.test.uibinder.UiObjectTag;
import com.googlecode.gwt.test.uibinder.UiObjectTagFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiDockLayoutPanelTagFactory
implements UiObjectTagFactory<DockLayoutPanel> {
    @Override
    public UiObjectTag<DockLayoutPanel> createUiObjectTag(Class<?> clazz, Map<String, Object> attributes) {
        if (!DockLayoutPanel.class.isAssignableFrom(clazz)) {
            return null;
        }
        return new UiDockLayoutPanelTag();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiDockLayoutPanelTag
    extends UiObjectTag<DockLayoutPanel> {
        private final List<IsWidget> centerWidgets = new ArrayList<IsWidget>();
        private double eastSize;
        private IsWidget eastWidget;
        private double northSize;
        private IsWidget northWidget;
        private double southSize;
        private IsWidget southWidget;
        private double westSize;
        private IsWidget westWidget;

        private UiDockLayoutPanelTag() {
        }

        @Override
        protected void appendElement(DockLayoutPanel wrapped, Element element, String namespaceURI, List<IsWidget> childWidgets) {
            if (!"urn:import:com.google.gwt.user.client.ui".equals(namespaceURI)) {
                super.appendElement(wrapped, element, namespaceURI, childWidgets);
            } else {
                this.handleDockLayoutPanelSpecifics(wrapped, element, childWidgets);
            }
        }

        @Override
        protected void finalizeObject(DockLayoutPanel widget) {
            if (this.northWidget != null) {
                widget.addNorth(this.northWidget, this.northSize);
            }
            if (this.southWidget != null) {
                widget.addSouth(this.southWidget, this.southSize);
            }
            if (this.eastWidget != null) {
                widget.addEast(this.eastWidget, this.eastSize);
            }
            if (this.westWidget != null) {
                widget.addWest(this.westWidget, this.westSize);
            }
            for (IsWidget centerWidget : this.centerWidgets) {
                widget.add(centerWidget);
            }
        }

        @Override
        protected void initializeObject(DockLayoutPanel wrapped, Map<String, Object> attributes, Object owner) {
        }

        @Override
        protected DockLayoutPanel instanciate(Class<? extends DockLayoutPanel> clazz, Map<String, Object> attributes, Object owner) {
            if (clazz == DockLayoutPanel.class) {
                String unit = (String)attributes.get("unit");
                Style.Unit styleUnit = unit != null ? Style.Unit.valueOf((String)unit) : Style.Unit.PX;
                return new DockLayoutPanel(styleUnit);
            }
            if (clazz == SplitLayoutPanel.class) {
                String splitterSize = (String)attributes.get("splitterSize");
                return splitterSize != null ? new SplitLayoutPanel(Integer.valueOf(splitterSize).intValue()) : new SplitLayoutPanel();
            }
            return super.instanciate(clazz, attributes, owner);
        }

        private void handleDockLayoutPanelSpecifics(DockLayoutPanel wrapped, Element child, List<IsWidget> childWidgets) {
            String tagName = child.getTagName();
            if ("center".equals(tagName)) {
                this.centerWidgets.addAll(childWidgets);
            } else if ("north".equals(tagName)) {
                String size = child.getPropertyString("size");
                this.northSize = StringUtils.isEmpty((String)size) ? 0.0 : Double.valueOf(size);
                this.northWidget = childWidgets.get(0);
            } else if ("south".equals(tagName)) {
                String size = child.getPropertyString("size");
                this.southSize = StringUtils.isEmpty((String)size) ? 0.0 : Double.valueOf(size);
                this.southWidget = childWidgets.get(0);
            } else if ("west".equals(tagName)) {
                String size = child.getPropertyString("size");
                this.westSize = StringUtils.isEmpty((String)size) ? 0.0 : Double.valueOf(size);
                this.westWidget = childWidgets.get(0);
            } else if ("east".equals(tagName)) {
                String size = child.getPropertyString("size");
                this.eastSize = StringUtils.isEmpty((String)size) ? 0.0 : Double.valueOf(size);
                this.eastWidget = childWidgets.get(0);
            }
        }
    }
}

