/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.rewrite;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.asm.ClassAdapter;
import com.google.gwt.dev.asm.ClassVisitor;
import com.google.gwt.dev.asm.MethodAdapter;
import com.google.gwt.dev.asm.MethodVisitor;
import com.google.gwt.dev.asm.Type;
import com.google.gwt.dev.asm.commons.Method;
import com.google.gwt.dev.shell.rewrite.HostedModeClassRewriter;
import com.google.gwt.dev.util.collect.Maps;
import com.google.gwt.dev.util.collect.Sets;
import com.googlecode.gwt.test.internal.rewrite.OverlayTypesRewriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RewriteSingleJsoImplDispatches
extends ClassAdapter {
    private String currentTypeName;
    private final Set<String> implementedMethods = new HashSet<String>();
    private boolean inSingleJsoImplInterfaceType;
    private Map<String, Set<String>> intfNamesToAllInterfaces = Maps.create();
    private final HostedModeClassRewriter.SingleJsoImplData jsoData;
    private final TypeOracle typeOracle;

    public RewriteSingleJsoImplDispatches(ClassVisitor v, TypeOracle typeOracle, HostedModeClassRewriter.SingleJsoImplData jsoData) {
        super(v);
        this.typeOracle = typeOracle;
        this.jsoData = jsoData;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        assert (this.currentTypeName == null);
        super.visit(version, access, name, signature, superName, interfaces);
        if (name.equals(OverlayTypesRewriter.JAVASCRIPTOBJECT_IMPL_DESC)) {
            return;
        }
        this.currentTypeName = name;
        this.inSingleJsoImplInterfaceType = this.jsoData.getSingleJsoIntfTypes().contains(name);
        if (interfaces != null && (access & 0x200) == 0) {
            Set<String> toStub = this.computeAllInterfaces(interfaces);
            toStub.retainAll(this.jsoData.getSingleJsoIntfTypes());
            for (String stubIntr : toStub) {
                this.writeTrampoline(stubIntr);
            }
        }
    }

    public void visitEnd() {
        if (this.inSingleJsoImplInterfaceType) {
            for (String mangledName : this.toImplement(this.currentTypeName)) {
                for (Method method : this.jsoData.getDeclarations(mangledName)) {
                    this.writeEmptyMethod(mangledName, method);
                }
            }
        }
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv;
        if (this.inSingleJsoImplInterfaceType && !"<clinit>".equals(name)) {
            name = this.currentTypeName.replace('/', '_') + "_" + name;
            this.implementedMethods.add(name);
        }
        if ((mv = super.visitMethod(access, name, desc, signature, exceptions)) == null) {
            return null;
        }
        return new MyMethodVisitor(mv);
    }

    private Set<String> computeAllInterfaces(String intfName) {
        Set toReturn = this.intfNamesToAllInterfaces.get(intfName);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = Sets.create();
        LinkedList<JClassType> q = new LinkedList<JClassType>();
        JClassType intf = this.typeOracle.findType(intfName.replace('/', '.').replace('$', '.'));
        if (intf != null) {
            q.add(intf);
        }
        while (!q.isEmpty()) {
            intf = (JClassType)q.remove(0);
            String resourceName = this.getResourceName(intf);
            if (toReturn.contains(resourceName)) continue;
            toReturn = Sets.add((Set)toReturn, (Object)resourceName);
            Collections.addAll(q, intf.getImplementedInterfaces());
        }
        this.intfNamesToAllInterfaces = Maps.put(this.intfNamesToAllInterfaces, (Object)intfName, (Object)toReturn);
        return toReturn;
    }

    private Set<String> computeAllInterfaces(String[] interfaces) {
        HashSet<String> toReturn = new HashSet<String>();
        for (String intfName : interfaces) {
            toReturn.addAll(this.computeAllInterfaces(intfName));
        }
        return toReturn;
    }

    private String getResourceName(JClassType type) {
        if (type.getEnclosingType() != null) {
            return this.getResourceName(type.getEnclosingType()) + "$" + type.getSimpleSourceName();
        }
        return type.getQualifiedSourceName().replace('.', '/');
    }

    private SortedSet<String> toImplement(String typeName) {
        String name = typeName.replace('/', '_');
        String prefix = name + "_";
        String suffix = name + "`";
        TreeSet<String> toReturn = new TreeSet<String>();
        for (String mangledName : this.jsoData.getMangledNames().subSet(prefix, suffix)) {
            if (this.implementedMethods.contains(mangledName)) continue;
            toReturn.add(mangledName);
        }
        return toReturn;
    }

    private void writeEmptyMethod(String mangledMethodName, Method declMethod) {
        MethodVisitor mv = super.visitMethod(1025, mangledMethodName, declMethod.getDescriptor(), null, null);
        mv.visitEnd();
    }

    private void writeTrampoline(String stubIntr) {
        for (String mangledName : this.toImplement(stubIntr)) {
            for (Method method : this.jsoData.getDeclarations(mangledName)) {
                Method toCall = new Method(method.getName(), method.getDescriptor());
                MethodVisitor mv = super.visitMethod(4097, mangledName, method.getDescriptor(), null, null);
                if (mv == null) continue;
                mv.visitCode();
                int var = 1;
                int size = 1;
                mv.visitVarInsn(25, 0);
                for (Type t : toCall.getArgumentTypes()) {
                    size += t.getSize();
                    mv.visitVarInsn(t.getOpcode(21), var);
                    var += t.getSize();
                }
                size = Math.max(size, toCall.getReturnType().getSize());
                mv.visitMethodInsn(182, this.currentTypeName, toCall.getName(), toCall.getDescriptor());
                mv.visitInsn(toCall.getReturnType().getOpcode(172));
                mv.visitMaxs(size, var);
                mv.visitEnd();
            }
        }
    }

    private class MyMethodVisitor
    extends MethodAdapter {
        public MyMethodVisitor(MethodVisitor mv) {
            super(mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 185) {
                if (RewriteSingleJsoImplDispatches.this.jsoData.getSingleJsoIntfTypes().contains(owner)) {
                    name = owner.replace('/', '_') + "_" + name;
                    assert (RewriteSingleJsoImplDispatches.this.jsoData.getMangledNames().contains(name)) : "Missing " + name;
                } else {
                    block0: for (String intf : RewriteSingleJsoImplDispatches.this.computeAllInterfaces(owner)) {
                        if (!RewriteSingleJsoImplDispatches.this.jsoData.getSingleJsoIntfTypes().contains(intf)) continue;
                        String maybeMangled = intf.replace('/', '_') + "_" + name;
                        List methods = RewriteSingleJsoImplDispatches.this.jsoData.getImplementations(maybeMangled);
                        if (methods == null) continue;
                        for (Method method : methods) {
                            assert (method.getArgumentTypes().length >= 1);
                            Type[] argumentTypes = new Type[method.getArgumentTypes().length - 1];
                            System.arraycopy(method.getArgumentTypes(), 1, argumentTypes, 0, argumentTypes.length);
                            String maybeDescriptor = Type.getMethodDescriptor((Type)method.getReturnType(), (Type[])argumentTypes);
                            if (!maybeDescriptor.equals(desc)) continue;
                            name = maybeMangled;
                            break block0;
                        }
                    }
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

