/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.patchers;

import com.googlecode.gwt.test.internal.AfterTestCallback;
import com.googlecode.gwt.test.internal.AfterTestCallbackManager;
import com.googlecode.gwt.test.patchers.PatchClass;
import com.googlecode.gwt.test.patchers.PatchMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

@PatchClass(value=com.google.gwt.user.client.Timer.class)
class TimerPatcher {
    private static final TimerHolder TIMER_HOLDER = new TimerHolder();

    TimerPatcher() {
    }

    @PatchMethod
    static void cancel(com.google.gwt.user.client.Timer timer) {
        TIMER_HOLDER.cancel(timer);
    }

    @PatchMethod
    static void schedule(final com.google.gwt.user.client.Timer timer, int delayMillis) throws Exception {
        if (delayMillis <= 0) {
            throw new IllegalArgumentException("must be positive");
        }
        TIMER_HOLDER.cancel(timer);
        Timer impl = new Timer();
        TIMER_HOLDER.hold(timer, impl);
        impl.schedule(new TimerTask(){

            public void run() {
                timer.run();
            }
        }, delayMillis);
    }

    @PatchMethod
    static void scheduleRepeating(final com.google.gwt.user.client.Timer timer, int periodMillis) throws Exception {
        if (periodMillis <= 0) {
            throw new IllegalArgumentException("must be positive");
        }
        TIMER_HOLDER.cancel(timer);
        Timer impl = new Timer();
        TIMER_HOLDER.hold(timer, impl);
        impl.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                timer.run();
            }
        }, periodMillis, (long)periodMillis);
    }

    private static class TimerHolder
    implements AfterTestCallback {
        private final Map<com.google.gwt.user.client.Timer, Timer> timers = new HashMap<com.google.gwt.user.client.Timer, Timer>();

        TimerHolder() {
            AfterTestCallbackManager.get().registerCallback(this);
        }

        public void afterTest() throws Throwable {
            for (Timer timer : this.timers.values()) {
                timer.cancel();
            }
            this.timers.clear();
        }

        void cancel(com.google.gwt.user.client.Timer timer) {
            if (!this.timers.containsKey(timer)) {
                return;
            }
            this.timers.get(timer).cancel();
        }

        void hold(com.google.gwt.user.client.Timer timer, Timer impl) {
            this.timers.put(timer, impl);
        }
    }
}

