/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal.i18n;

import com.google.gwt.i18n.client.LocalizableResource;
import com.googlecode.gwt.test.exceptions.GwtTestI18NException;
import com.googlecode.gwt.test.internal.GwtConfig;
import com.googlecode.gwt.test.internal.utils.GwtPropertiesHelper;
import com.googlecode.gwt.test.utils.GwtReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LocalizableResourceInvocationHandler
implements InvocationHandler {
    private final Class<? extends LocalizableResource> proxiedClass;

    public LocalizableResourceInvocationHandler(Class<? extends LocalizableResource> proxiedClass) {
        this.proxiedClass = proxiedClass;
    }

    public Class<? extends LocalizableResource> getProxiedClass() {
        return this.proxiedClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = this.extractLocaleSpecificValue(this.proxiedClass, method, args);
        if (result != null) {
            return result;
        }
        result = this.recurseExtractFromParentLocaleSpecificResource(this.proxiedClass.getInterfaces(), method, args);
        if (result != null) {
            return result;
        }
        result = this.extractFromDefaultProperties(this.proxiedClass, method, args);
        Properties prop = GwtPropertiesHelper.get().getProperties(this.getPropertiesFilePrefix(this.proxiedClass));
        if (prop != null && (result = this.extractFromProperties(prop, method, args, null)) != null) {
            return result;
        }
        result = this.recurseExtractFromParentResource(this.proxiedClass.getInterfaces(), method, args);
        if (result != null) {
            return result;
        }
        result = this.extractDefaultValue(method, args);
        if (result != null) {
            return result;
        }
        throw new GwtTestI18NException("Unable to find a Locale specific resource file to bind with i18n interface '" + this.proxiedClass.getName() + "' and there is no @DefaultXXXValue annotation on '" + method.getName() + "' called method");
    }

    protected abstract Object extractDefaultValue(Method var1, Object[] var2) throws Throwable;

    protected abstract Object extractFromProperties(Properties var1, Method var2, Object[] var3, Locale var4) throws Throwable;

    protected String getKey(Method method) {
        LocalizableResource.Key key = method.getAnnotation(LocalizableResource.Key.class);
        return key != null ? key.value() : method.getName();
    }

    protected Locale getLocale() {
        if (GwtConfig.get().getModuleRunner().getLocale() != null) {
            return GwtConfig.get().getModuleRunner().getLocale();
        }
        LocalizableResource.DefaultLocale annotation = GwtReflectionUtils.getAnnotation(this.proxiedClass, LocalizableResource.DefaultLocale.class);
        if (annotation != null) {
            String[] localeCodes = annotation.value().split("_");
            switch (localeCodes.length) {
                case 1: {
                    return new Locale(localeCodes[0]);
                }
                case 2: {
                    return new Locale(localeCodes[0], localeCodes[1]);
                }
            }
            throw new GwtTestI18NException("Cannot parse Locale value in annoted class [" + this.proxiedClass.getSimpleName() + "] : @" + LocalizableResource.DefaultLocale.class.getSimpleName() + "(" + annotation.value() + ")");
        }
        return null;
    }

    private Object extractFromDefaultProperties(Class<?> clazz, Method method, Object[] args) throws Throwable {
        Properties prop = GwtPropertiesHelper.get().getProperties(this.getPropertiesFilePrefix(clazz));
        if (prop != null) {
            return this.extractFromProperties(prop, method, args, this.getLocale());
        }
        return null;
    }

    private Object extractLocaleSpecificValue(Class<?> localizableResourceClass, Method method, Object[] args) throws Throwable {
        Object result = null;
        Locale locale = this.getLocale();
        Properties prop = GwtPropertiesHelper.get().getLocalizedProperties(this.getPropertiesFilePrefix(localizableResourceClass), locale);
        if (prop != null) {
            result = this.extractFromProperties(prop, method, args, locale);
        }
        return result;
    }

    private String getPropertiesFilePrefix(Class<?> localizableResourceClass) {
        return localizableResourceClass.getCanonicalName().replaceAll("\\.", "/");
    }

    private Object recurseExtractFromParentLocaleSpecificResource(Class<?>[] interfaces, Method method, Object[] args) throws Throwable {
        for (Class<?> inter : interfaces) {
            if (!LocalizableResource.class.isAssignableFrom(inter)) continue;
            Object result = this.extractLocaleSpecificValue(inter, method, args);
            if (result != null) {
                return result;
            }
            return this.recurseExtractFromParentLocaleSpecificResource(inter.getInterfaces(), method, args);
        }
        return null;
    }

    private Object recurseExtractFromParentResource(Class<?>[] interfaces, Method method, Object[] args) throws Throwable {
        for (Class<?> inter : interfaces) {
            if (!LocalizableResource.class.isAssignableFrom(inter)) continue;
            Object result = this.extractFromDefaultProperties(inter, method, args);
            if (result != null) {
                return result;
            }
            return this.recurseExtractFromParentResource(inter.getInterfaces(), method, args);
        }
        return null;
    }
}

