/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test.internal;

import com.googlecode.gwt.test.exceptions.GwtTestPatchException;
import com.googlecode.gwt.test.internal.GwtClassPool;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.CtClass;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ClassesScanner {
    private static final ClassesScanner INSTANCE = new ClassesScanner();
    private static Logger logger = LoggerFactory.getLogger(ClassesScanner.class);

    public static ClassesScanner getInstance() {
        return INSTANCE;
    }

    private ClassesScanner() {
    }

    public void scanPackages(ClassVisitor classVisitor, Set<String> rootPackages) {
        for (String rootPackage : rootPackages) {
            String path = rootPackage.replaceAll("\\.", "/");
            logger.debug("Scan package " + rootPackage);
            if (rootPackage.endsWith(".")) {
                rootPackage = rootPackage.substring(0, rootPackage.length() - 1);
            }
            try {
                Enumeration<URL> l = Thread.currentThread().getContextClassLoader().getResources(path);
                while (l.hasMoreElements()) {
                    URL url = l.nextElement();
                    String u = url.toExternalForm();
                    if (u.startsWith("file:")) {
                        String directoryName = u.substring("file:".length());
                        directoryName = URLDecoder.decode(directoryName, "UTF-8");
                        this.scanClassesFromDirectory(new File(directoryName), rootPackage, classVisitor);
                        continue;
                    }
                    if (u.startsWith("jar:file:")) {
                        this.scanClassesFromJarFile(u.substring("jar:file:".length()), path, classVisitor);
                        continue;
                    }
                    throw new IllegalArgumentException("Not managed class container " + u);
                }
            }
            catch (Exception e) {
                throw new GwtTestPatchException("Error while scanning package '" + rootPackage + "'", e);
            }
        }
    }

    private void scanClassesFromDirectory(File directoryToScan, String scanPackage, ClassVisitor classVisitor) {
        logger.debug("Scan directory " + directoryToScan);
        for (File f : directoryToScan.listFiles()) {
            if (f.isDirectory()) {
                if (".".equals(f.getName()) || "..".equals(f.getName())) continue;
                this.scanClassesFromDirectory(f, scanPackage + "." + f.getName(), classVisitor);
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            this.visitClass(scanPackage + "." + f.getName(), classVisitor);
        }
        logger.debug("Directory scanned " + directoryToScan);
    }

    private void scanClassesFromJarFile(String path, String scanPackage, ClassVisitor classVisitor) throws Exception {
        String prefix = path.substring(path.indexOf("!") + 2);
        String jarName = path.substring(0, path.indexOf("!"));
        jarName = URLDecoder.decode(jarName, "UTF-8");
        logger.debug("Load classes from jar " + jarName);
        JarFile jar = new JarFile(jarName);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(prefix) || !entry.getName().endsWith(".class")) continue;
            this.visitClass(entry.getName().replaceAll("\\/", "."), classVisitor);
        }
        logger.debug("Classes loaded from jar " + jarName);
    }

    private void visitClass(String classFileName, ClassVisitor classVisitor) {
        try {
            CtClass current = GwtClassPool.getClass(classFileName.substring(0, classFileName.length() - ".class".length()));
            classVisitor.visit(current);
            for (CtClass innerClass : current.getNestedClasses()) {
                classVisitor.visit(innerClass);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    static interface ClassVisitor {
        public void visit(CtClass var1);
    }
}

