/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gwt.test;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.util.log.AbstractTreeLogger;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtTreeLogger
extends AbstractTreeLogger {
    private static final String DEFAULT_BRANCH_INDENT = "   ";
    private static final List<ErrorDto> ERROR_MSG_BUFFER = new ArrayList<ErrorDto>();
    private static final GwtTreeLogger INSTANCE = new GwtTreeLogger("");
    private static int lastIndexOfErrorWithinParentLogger = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(GwtTreeLogger.class);
    private final String indent;

    public static GwtTreeLogger get() {
        return INSTANCE;
    }

    public static void reset() {
        lastIndexOfErrorWithinParentLogger = -1;
    }

    private GwtTreeLogger(String indent) {
        this.indent = indent;
    }

    public void onUnableToCompleteError() {
        for (ErrorDto error : ERROR_MSG_BUFFER) {
            if (error.helpInfo == null || error.helpInfo.getURL() == null) {
                LOGGER.error(error.msg, error.caught);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(error.msg);
            sb.append(" (for additional info see:").append(error.helpInfo.getURL().toString());
            LOGGER.error(sb.toString(), error.caught);
        }
        ERROR_MSG_BUFFER.clear();
    }

    protected AbstractTreeLogger doBranch() {
        return new GwtTreeLogger(this.indent + DEFAULT_BRANCH_INDENT);
    }

    protected void doCommitBranch(AbstractTreeLogger childBeingCommitted, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        this.doLog(childBeingCommitted.getBranchedIndex(), type, msg, caught, helpInfo);
    }

    protected void doLog(int indexOfLogEntryWithinParentLogger, TreeLogger.Type type, String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
        if (lastIndexOfErrorWithinParentLogger > -1 && indexOfLogEntryWithinParentLogger < lastIndexOfErrorWithinParentLogger) {
            ErrorDto baseError = ERROR_MSG_BUFFER.get(ERROR_MSG_BUFFER.size() - 1);
            ERROR_MSG_BUFFER.clear();
            ERROR_MSG_BUFFER.add(baseError);
        }
        switch (type) {
            case DEBUG: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug(this.indent + msg, caught);
                break;
            }
            case ERROR: {
                if (!LOGGER.isErrorEnabled()) break;
                ERROR_MSG_BUFFER.add(new ErrorDto(msg, caught, helpInfo));
                lastIndexOfErrorWithinParentLogger = indexOfLogEntryWithinParentLogger;
                break;
            }
            case INFO: {
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info(this.indent + msg, caught);
                break;
            }
            case WARN: {
                if (!LOGGER.isWarnEnabled()) break;
                LOGGER.warn(this.indent + msg, caught);
                break;
            }
        }
    }

    private static final class ErrorDto {
        private final Throwable caught;
        private final TreeLogger.HelpInfo helpInfo;
        private final String msg;

        private ErrorDto(String msg, Throwable caught, TreeLogger.HelpInfo helpInfo) {
            this.msg = msg;
            this.caught = caught;
            this.helpInfo = helpInfo;
        }
    }
}

