/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl.xydra;

import com.google.web.bindery.event.shared.EventBus;
import de.xam.cmodel.fact.CEntity;
import de.xam.cmodel.fact.CFactSource;
import de.xam.cmodel.fact.CFactory;
import de.xam.cmodel.fact.CSymbol;
import de.xam.cmodel.fact.CTriple;
import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.cmodel.fact.VocabularyCModel;
import de.xam.itemset.ConfParamsItemSet;
import de.xam.itemset.IEntity;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.IProperty;
import de.xam.itemset.IStatement;
import de.xam.itemset.impl.ItemSet_PropertyIndex;
import de.xam.itemset.impl.ItemSet_StatementIndex;
import de.xam.itemset.impl.ManagedTripleIndex;
import de.xam.itemset.impl.xydra.ItemXy;
import de.xam.itemset.impl.xydra.PropertyXy;
import de.xam.itemset.impl.xydra.StatementXy;
import de.xam.itemset.impl.xydra.XydraWrapper;
import de.xam.itemset.index.IDepend;
import de.xam.itemset.index.IndexManager;
import de.xam.p13n.shared.time.TimeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.base.XId;
import org.xydra.base.minio.MiniReader;
import org.xydra.base.minio.MiniWriter;
import org.xydra.base.rmof.XReadableModel;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.core.model.XModel;
import org.xydra.core.serialize.SerializedModel;
import org.xydra.core.serialize.XydraElement;
import org.xydra.core.serialize.XydraOut;
import org.xydra.core.serialize.xml.XmlOut;
import org.xydra.core.serialize.xml.XmlParser;
import org.xydra.index.ITripleIndex;
import org.xydra.index.impl.FastSerializableTripleIndex;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.ITriple;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class ItemSetXy
implements IItemSet,
IDepend {
    private static final Logger log = LoggerFactory.getLogger(ItemSetXy.class);
    private final IChangeData changeData;
    private final IndexManager internalIndexManager;
    private final ItemSet_PropertyIndex internalPropertyIndex;
    private final ItemSet_StatementIndex internalStatementIndex;
    private final ManagedTripleIndex managedTripleIndex;
    protected XydraWrapper xydraWrapper;

    public static ItemSetXy createWithoutInference(EventBus eventBus) {
        return new ItemSetXy(eventBus, (ITripleIndex<XId, XId, XId>)new FastSerializableTripleIndex());
    }

    public static XModel readFromXmlMiniReader(MiniReader miniReader) {
        XmlParser parser = new XmlParser();
        XydraElement xe = parser.parse(miniReader);
        XId actorId = ConfParamsItemSet._ACTOR_LOCALHOST;
        String passwordHash = "localhost";
        XModel xmodel = SerializedModel.toModel((XId)actorId, (String)"localhost", (XydraElement)xe);
        return xmodel;
    }

    public static void writeToXmlMiniWriter(XModel xmodel, MiniWriter miniWriter) {
        XmlOut xmlOut = new XmlOut(miniWriter);
        xmlOut.enableWhitespace(true, true);
        SerializedModel.serialize((XReadableModel)xmodel, (XydraOut)xmlOut);
        miniWriter.flush();
        miniWriter.close();
    }

    public ItemSetXy(EventBus eventBus, ITripleIndex<XId, XId, XId> sharedTripleIndex) {
        XydraWrapper xydraWrapper = new XydraWrapper(eventBus);
        XModel model = xydraWrapper.createXModel();
        xydraWrapper.setModel(model);
        this.xydraWrapper = xydraWrapper;
        this.xydraWrapper.setItemSet(this);
        this.changeData = ChangeDatas.createWithCreationDate_Now((String)"_system", (String)"ItemSetXy");
        this.internalIndexManager = new IndexManager("ItemSetXy-internal", this);
        this.managedTripleIndex = new ManagedTripleIndex(sharedTripleIndex, this.internalIndexManager);
        this.internalStatementIndex = new ItemSet_StatementIndex(this.getId(), this.internalIndexManager);
        this.internalPropertyIndex = new ItemSet_PropertyIndex(this.getId(), this.internalIndexManager);
        this.internalIndexManager.clearAndMarkAsComputed();
        this.internalIndexManager.setUpdating(true);
        assert (this.isEmpty());
    }

    @Override
    public void addItem(IItem item) {
        if (item.getChangeData().getCreationDateUTC() == 0L) {
            item.setAttribute(VocabularyCModel.ATTRIBUTE_CREATION_DATE, (XValue)XV.toValue((long)TimeProvider.getCurrentTimeInMillis()));
        }
        this.xydraWrapper.addItem(item);
    }

    @Override
    public void addProperty(IProperty property) {
        assert (property.getSourceEntityId() != null);
        assert (property.getPropertyKey() != null);
        assert (property.getWritableContent().getContentValue() != null);
        this.xydraWrapper.addProperty(property);
    }

    @Override
    public void addStatement(IStatement statement) {
        assert (statement.getTriple() != null);
        assert (statement.getTriple().s() != null);
        assert (statement.getTriple().p() != null);
        assert (statement.getTriple().o() != null);
        this.xydraWrapper.addStatement(statement);
    }

    public Iterator<XId> attributes() {
        return this.xydraWrapper.attributes();
    }

    @Override
    public void clear() {
        this.xydraWrapper.clearXModelAndChangeLog();
        this.internalStatementIndex.clear();
        this.internalPropertyIndex.clear();
    }

    @Override
    public IProperty createAndAddProperty(XId propertyId, XId sourceEntityId, XId propertyKey, String contentString, String contentTypeString, IChangeData changeData) throws IllegalArgumentException {
        IProperty prop = this.xydraWrapper.createAndAddProperty(propertyId, sourceEntityId, propertyKey, contentString, contentTypeString, changeData);
        return prop;
    }

    @Override
    public IProperty createAndAddProperty(XId propertyId, XId sourceEntityId, XId propertyKey, XValue propertyValue, IChangeData changeData) throws IllegalArgumentException {
        IProperty prop = this.xydraWrapper.createAndAddProperty(propertyId, sourceEntityId, propertyKey, propertyValue, changeData);
        return prop;
    }

    @Override
    public IStatement createAndAddStatement(XId statementId, XId s, XId p, XId o, IChangeData changeData) throws IllegalArgumentException {
        return this.xydraWrapper.createAndAddStatement(statementId, s, p, o, changeData);
    }

    @Override
    public XModel createXModel() {
        return this.xydraWrapper.createXModel();
    }

    @Override
    public boolean deleteItem(XId itemId, IChangeData changeData) {
        return this.xydraWrapper.deleteItem(itemId, changeData);
    }

    @Override
    public boolean deleteProperty(XId propertyId, IChangeData changeData) {
        return this.xydraWrapper.deleteProperty(propertyId, changeData);
    }

    @Override
    public boolean deleteStatement(XId statementId, IChangeData changeData) {
        return this.xydraWrapper.deleteStatement(statementId, changeData);
    }

    public String dump() {
        log.info(this.toString());
        return "";
    }

    @Override
    public CFactory factory() {
        return this.xydraWrapper.factory();
    }

    public XValue getAttribute(XId attributeId) {
        return this.xydraWrapper.getAttribute(attributeId);
    }

    public IChangeData getChangeData() {
        return this.changeData;
    }

    public CFactSource getContextModel() {
        return null;
    }

    @Override
    public Collection<?> getDependencies() {
        return Arrays.asList(this.internalPropertyIndex, this.internalStatementIndex);
    }

    public Iterator<CEntity> getEntities() {
        Iterator symbolIt = Iterators.typeCast(this.getSymbols());
        Iterator tripleIt = Iterators.typeCast(this.getTriples());
        return Iterators.concat((Iterator)symbolIt, (Iterator)tripleIt);
    }

    @Override
    public IEntity getEntityById(XId entityId) {
        return this.xydraWrapper.getEntityById(entityId);
    }

    @Override
    public EventBus getEventBus() {
        return this.xydraWrapper.getEventBus();
    }

    public XId getId() {
        return this.xydraWrapper.getId();
    }

    @Override
    public ItemXy getItemById(XId itemId) {
        return this.xydraWrapper.getItemById(itemId);
    }

    @Override
    public ItemXy getOrCreateAndAddItem(XId itemId, IChangeData changeData) throws IllegalArgumentException {
        ItemXy item = this.xydraWrapper.getItemById(itemId);
        if (item != null) {
            return item;
        }
        return this.xydraWrapper.createAndAddItem(itemId, changeData);
    }

    @Override
    public Set<IProperty> getPropertiesFor(XId s, XId p) {
        Iterator<IProperty> it = s == null ? (p == null ? this.properties_all() : this.properties_Xp(p)) : (p == null ? this.properties_sX(s) : this.properties_sp(s, p));
        Set set = Iterators.toSet(it);
        return set;
    }

    @Override
    public PropertyXy getPropertyById(XId stmtId) {
        return this.xydraWrapper.getPropertyById(stmtId);
    }

    @Override
    public StatementXy getStatementById(XId stmtId) {
        return this.xydraWrapper.getStatementById(stmtId);
    }

    @Override
    public Set<IStatement> getStatementsFor(XId s, XId p, XId o) {
        this.internalIndexManager.getIndexState(this.internalStatementIndex).assertIs_computed_updating(true, true);
        HashSet<IStatement> set = new HashSet<IStatement>();
        Iterator matchingTriples = this.getTripleIndex().getTriples((Object)s, (Object)p, (Object)o);
        while (matchingTriples.hasNext()) {
            ITriple matchingTriple = (ITriple)matchingTriples.next();
            Iterator<IStatement> stmtIt = this.internalStatementIndex.getStatementsForTriple((ITriple<XId, XId, XId>)matchingTriple);
            assert (stmtIt.hasNext());
            Iterators.addAll(stmtIt, set);
        }
        return set;
    }

    public String getStats() {
        return "itemSetXy";
    }

    public Iterator<CSymbol> getSymbols() {
        return this.xydraWrapper.getSymbols();
    }

    @Override
    public ITripleIndex<XId, XId, XId> getTripleIndex() {
        assert (this.internalIndexManager.getIndexState(this.internalStatementIndex).assertIs_computed_updating(true, true));
        return this.managedTripleIndex;
    }

    public Iterator<CTriple> getTriples() {
        return this.xydraWrapper.getTriples();
    }

    @Override
    public XModel getXModel() {
        return this.xydraWrapper.getXModel();
    }

    @Override
    public boolean hasItemWithId(XId itemId) {
        return this.xydraWrapper.hasItemWithId(itemId);
    }

    @Override
    public void indexAsNewStatement(XId s, XId p, XId o, IChangeData changeData, Map<XId, XValue> attributes) {
        this.xydraWrapper.indexAsNewStatement(s, p, o, changeData, attributes);
    }

    public IndexManager indexManager() {
        return this.internalIndexManager;
    }

    @Override
    public boolean isEmpty() {
        return this.xydraWrapper.isEmpty();
    }

    @Override
    public long itemCount() {
        return this.xydraWrapper.itemCount();
    }

    @Override
    public Iterator<IItem> items() {
        return this.xydraWrapper.items();
    }

    @Override
    public Iterator<XId> iterator() {
        return this.xydraWrapper.iterator();
    }

    @Override
    public Iterator<IProperty> properties() {
        return this.xydraWrapper.properties();
    }

    private Iterator<IProperty> properties_all() {
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).ensureIsComputed(null);
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).assertIs_computed_updating(true, true);
        return this.internalPropertyIndex.properties_all();
    }

    private Iterator<IProperty> properties_sp(XId s, XId p) {
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).ensureIsComputed(null);
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).assertIs_computed_updating(true, true);
        return this.internalPropertyIndex.properties_sp(s, p);
    }

    private Iterator<IProperty> properties_sX(XId s) {
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).ensureIsComputed(null);
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).assertIs_computed_updating(true, true);
        return this.internalPropertyIndex.properties_sX(s);
    }

    private Iterator<IProperty> properties_Xp(XId p) {
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).ensureIsComputed(null);
        this.internalIndexManager.getIndexState(this.internalPropertyIndex).assertIs_computed_updating(true, true);
        return this.internalPropertyIndex.properties_Xp(p);
    }

    @Override
    public void readFromXml(MiniReader miniReader) {
        XModel xmodel = ItemSetXy.readFromXmlMiniReader(miniReader);
        this.xydraWrapper.setModel(xmodel);
    }

    @Override
    public void renameIds(Map<XId, XId> rename) {
        this.xydraWrapper.renameIds(rename);
    }

    public boolean setAttribute(XId attributeId, XValue attributeValue) {
        return this.xydraWrapper.setAttribute(attributeId, attributeValue);
    }

    @Override
    public void setBaseTripleIndex(ITripleIndex<XId, XId, XId> baseTripleIndex) {
        this.managedTripleIndex.setTripleIndex(baseTripleIndex);
    }

    @Override
    public void setXModel(XModel model, boolean contentUpdateEvents, boolean statementEvents, boolean propertyEvents, boolean attributeEvents) {
        this.xydraWrapper.setModel(model);
        if (contentUpdateEvents || statementEvents || propertyEvents || attributeEvents) {
            this.xydraWrapper.refireEvents(contentUpdateEvents, statementEvents, propertyEvents, attributeEvents);
        }
    }

    @Override
    public int statementCount() {
        return this.xydraWrapper.statementCount();
    }

    @Override
    public Iterator<IStatement> statements() {
        return this.xydraWrapper.statements();
    }

    public String toDebugString() {
        return this.xydraWrapper.toDebugString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Items\n");
        Iterator<IItem> iit = this.items();
        while (iit.hasNext()) {
            IItem item = iit.next();
            b.append(item.toString()).append("\n");
        }
        b.append("Statements\n");
        Iterator<IStatement> sit = this.statements();
        while (sit.hasNext()) {
            IStatement stmt = sit.next();
            b.append(stmt.toString()).append("\n");
        }
        return b.toString();
    }

    @Override
    public void writeToXml(MiniWriter miniWriter) {
        ItemSetXy.writeToXmlMiniWriter(this.getXModel(), miniWriter);
    }
}

