/*
 * Decompiled with CFR 0.152.
 */
package de.xam.itemset.impl;

import de.xam.cmodel.fact.CTriple;
import de.xam.itemset.IStatement;
import de.xam.itemset.index.IItemSetStatementIndex;
import de.xam.itemset.index.IndexManager;
import de.xam.itemset.index.IndexState;
import java.io.Serializable;
import java.util.Iterator;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.index.impl.SerializableMapSetIndex;
import org.xydra.index.query.ITriple;

public class ItemSet_StatementIndex
implements Serializable,
IItemSetStatementIndex {
    private final XId id;
    private final SerializableMapSetIndex<ITriple<XId, XId, XId>, IStatement> tripleId2statements;
    private final IndexState indexState;

    public ItemSet_StatementIndex(XId itemSetId, IndexManager indexManager) {
        this.id = Base.toId((String)(itemSetId + "-internalStmtIndex"));
        this.tripleId2statements = SerializableMapSetIndex.createWithSmallEntrySets();
        this.indexState = indexManager.register(this, this.getId(), "Internal Statement-Index");
    }

    public void clear() {
        this.tripleId2statements.clear();
    }

    @Override
    public boolean ensureIsComputed(IndexManager.IIndexProgress indexProgress) {
        return this.indexState.ensureIsComputed(indexProgress);
    }

    @Override
    public boolean isComputed() {
        return this.indexState.isComputed();
    }

    public XId getId() {
        return this.id;
    }

    public Iterator<IStatement> getStatementsForTriple(ITriple<XId, XId, XId> matchingTriple) {
        this.ensureIsComputed(null);
        return this.tripleId2statements.valueIterator(matchingTriple);
    }

    @Override
    public String getStats() {
        this.ensureIsComputed(null);
        return "tripleIndex=... tripleId2statements=" + this.tripleId2statements.keySet().size();
    }

    public boolean isEmpty() {
        this.ensureIsComputed(null);
        return this.tripleId2statements.isEmpty();
    }

    @Override
    public void onStatementAdd(IStatement stmt) throws Exception {
        CTriple triple = stmt.getTriple();
        this.tripleId2statements.index((Object)triple, (Object)stmt);
    }

    @Override
    public void onStatementChange(IStatement stmt) throws Exception {
    }

    @Override
    public void onStatementRemove(IStatement stmt) throws Exception {
        CTriple triple = stmt.getTriple();
        this.tripleId2statements.deIndex((Object)triple, (Object)stmt);
    }

    @Override
    public int size() {
        this.ensureIsComputed(null);
        return this.tripleId2statements.size();
    }
}

