/*
 * Decompiled with CFR 0.152.
 */
package org.xydra.gaemyadmin;

import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.memcache.Stats;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.xydra.gaemyadmin.AppConstants;
import org.xydra.gaemyadmin.GaeMyAdmin_GaeTestfixer;
import org.xydra.restless.Restless;
import org.xydra.restless.RestlessParameter;
import org.xydra.restless.utils.SharedHtmlUtils;

public class MemcacheAdminResource {
    static final String PAGE_NAME = "Memcache Admin";
    static String URL;

    public static void restless(Restless restless, String prefix) {
        URL = prefix + "/memcache";
        restless.addMethod(URL, "GET", MemcacheAdminResource.class, "index", true, new RestlessParameter[0]);
        restless.addMethod(URL + "/stats", "GET", MemcacheAdminResource.class, "stats", true, new RestlessParameter[0]);
        restless.addMethod(URL + "/clear", "GET", MemcacheAdminResource.class, "clear", true, new RestlessParameter[0]);
    }

    public void index(HttpServletResponse res) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "");
        w.write(SharedHtmlUtils.toOrderedList(Arrays.asList(SharedHtmlUtils.link((String)("/admin" + URL + "/stats"), (String)"Memcache Statistics"), SharedHtmlUtils.link((String)("/admin" + URL + "/clear"), (String)"Clear Memcache"))));
        AppConstants.endPage(w);
    }

    public void stats(HttpServletResponse res) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "Stats");
        w.write("Loading stats...");
        w.flush();
        MemcacheService mcs = MemcacheServiceFactory.getMemcacheService();
        w.write("<h2>Namespace: " + mcs.getNamespace() + "</h2>");
        Stats stats = mcs.getStatistics();
        if (stats == null) {
            w.write("No stats available.");
        } else {
            w.write(SharedHtmlUtils.toOrderedList(Arrays.asList("BytesReturnedForHits: " + stats.getBytesReturnedForHits(), "HitCount: " + stats.getHitCount(), "ItemCount: " + stats.getItemCount(), "MaxTimeWithoutAccess: " + stats.getMaxTimeWithoutAccess(), "MissCount: " + stats.getMissCount(), "TotalItemBytes: " + stats.getTotalItemBytes())));
        }
        AppConstants.endPage(w);
    }

    public void clear(HttpServletResponse res) throws IOException {
        GaeMyAdmin_GaeTestfixer.initialiseHelperAndAttachToCurrentThread();
        Writer w = AppConstants.startPage(res, PAGE_NAME, "Clear");
        w.write("Clearing memcache ...");
        w.flush();
        MemcacheService mcs = MemcacheServiceFactory.getMemcacheService();
        mcs.clearAll();
        w.write("Done.");
        AppConstants.endPage(w);
    }
}

