/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.tokenize;

import com.google.common.collect.Lists;
import com.google.gwt.regexp.shared.SplitResult;
import de.xam.texthtml.text.CamelCase;
import de.xam.texthtml.text.Unicodes;
import de.xam.textsearch.tokenize.ITokenizer;
import de.xam.textsearch.tokenize.RangeBasedTokenizer;
import de.xam.textsearch.tokenize.RegexTokenizer;
import de.xam.textsearch.util.TextIndexTool;
import java.util.ArrayList;
import java.util.Iterator;
import org.xydra.index.IIntegerRangeIndex;

public class Tokenizers {
    public static final ITokenizer SPACE = new RegexTokenizer("[ ]");
    static String PHRASE2WORDREGEX = "[ \\r\\n\\t]+";
    static final String WORD2TOKENSREGEX = "[ _,:;!?'@*/\"\\-\\.\\(\\)\\{\\}\\\\\\n\\r\\t&#+<=>~$%|\u00a7]+";
    public static final ITokenizer WORD_OR_PHRASE_2_FRAGMENT_TOKENIZER__RANGEBASED = new ITokenizer(){

        @Override
        public synchronized SplitResult split(String word) {
            assert (word != null);
            ArrayList<String> fragments = new ArrayList<String>();
            SplitResult tokenSplit = WORD_2_TOKEN_TOKENIZER__RANGEBASED.split(word);
            for (int i = 0; i < tokenSplit.length(); ++i) {
                String token = tokenSplit.get(i);
                SplitResult fragmentSplit = TOKEN_2_FRAGMENT_TOKENIZER.split(token);
                for (int j = 0; j < fragmentSplit.length(); ++j) {
                    if (fragments.contains(fragmentSplit.get(j))) continue;
                    fragments.add(fragmentSplit.get(j));
                }
            }
            return new SplitResult(Lists.newArrayList(fragments).toArray(new String[fragments.size()]));
        }
    };
    public static final ITokenizer PHRASE_2_WORD_TOKENIZER__RANGEBASED = new RangeBasedTokenizer((IIntegerRangeIndex)Unicodes.unicodePureSeparator);
    public static final ITokenizer WORD_2_TOKEN_TOKENIZER__RANGEBASED = new RangeBasedTokenizer((IIntegerRangeIndex)Unicodes.unicodeSeparator_or_mixed);
    public static final ITokenizer TOKEN_2_FRAGMENT_TOKENIZER = new ITokenizer(){

        @Override
        public synchronized SplitResult split(String token) {
            ArrayList<String> fragments = new ArrayList<String>();
            String[] tokenFragments = CamelCase.splitCamelCaseAndDigits((String)token);
            for (int j = 0; j < tokenFragments.length; ++j) {
                if (fragments.contains(tokenFragments[j])) continue;
                fragments.add(tokenFragments[j]);
            }
            return new SplitResult(fragments.toArray(new String[fragments.size()]));
        }
    };

    public static Iterator<String> tokenizeToIterator(String word, ITokenizer tokenizer) {
        return new TextIndexTool.SplitResultIterator(tokenizer.split(word));
    }
}

