/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.tokenize;

import com.google.gwt.regexp.shared.SplitResult;
import de.xam.texthtml.text.Unicodes;
import de.xam.textsearch.tokenize.ITokenizer;
import java.util.ArrayList;
import org.xydra.index.IIntegerRangeIndex;
import org.xydra.index.impl.IntegerRangeIndex;

public class RangeBasedTokenizer
implements ITokenizer {
    private final IIntegerRangeIndex separators;

    public RangeBasedTokenizer(IIntegerRangeIndex separators) {
        this.separators = separators;
    }

    @Override
    public synchronized SplitResult split(final String term) {
        assert (term != null);
        final ArrayList resultList = new ArrayList();
        IntegerRangeIndex.split((String)term, (int)0, (int)term.length(), (IIntegerRangeIndex)this.separators, (IntegerRangeIndex.ISplitHandler)new IntegerRangeIndex.ISplitHandler(){

            public void onToken(int startInclusive, int endExclusive) {
                String token = term.substring(startInclusive, endExclusive);
                resultList.add(token);
            }

            public void onSeparator(int startInclusive, int endExclusive) {
            }

            public void onDone() {
            }
        });
        String[] result = resultList.toArray(new String[resultList.size()]);
        SplitResult splitResult = new SplitResult(result);
        return splitResult;
    }

    public static void main(String[] args) {
        String s = "Hello World--this is a 123\u00e4+test";
        IntegerRangeIndex.split((String)"Hello World--this is a 123\u00e4+test", (int)0, (int)"Hello World--this is a 123\u00e4+test".length(), (IIntegerRangeIndex)Unicodes.unicodeSeparator_or_mixed, (IntegerRangeIndex.ISplitHandler)new IntegerRangeIndex.ISplitHandler(){

            public void onToken(int startInclusive, int endExclusive) {
                System.out.println("token '" + "Hello World--this is a 123\u00e4+test".substring(startInclusive, endExclusive) + "'");
            }

            public void onSeparator(int startInclusive, int endExclusive) {
                System.out.println("sep '" + "Hello World--this is a 123\u00e4+test".substring(startInclusive, endExclusive) + "'");
            }

            public void onDone() {
            }
        });
    }
}

