/*
 * Decompiled with CFR 0.152.
 */
package de.xam.textsearch.fragment;

import de.xam.textsearch.fragment.FragmentQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.xydra.index.Factory;
import org.xydra.index.IEntrySet;
import org.xydra.index.IMapSetIndex;
import org.xydra.index.ISerializableMapSetIndex;
import org.xydra.index.impl.FastEntrySetFactory;
import org.xydra.index.impl.SmallFastListBasedSet;
import org.xydra.index.impl.trie.SmallTrieStringMapSetIndex;
import org.xydra.index.iterator.ClosableIterator;
import org.xydra.index.iterator.IFilter;
import org.xydra.index.iterator.ITransformer;
import org.xydra.index.iterator.Iterators;
import org.xydra.index.query.Constraint;
import org.xydra.index.query.KeyEntryTuple;
import org.xydra.index.query.Pair;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class FragmentIndex<V extends Serializable>
implements ISerializableMapSetIndex<String, V> {
    private static final long serialVersionUID = 1L;
    private SmallTrieStringMapSetIndex<V> trie = new SmallTrieStringMapSetIndex((Factory)new FastEntrySetFactory(true));
    private static final Logger log = LoggerFactory.getLogger(FragmentIndex.class);

    public void clear() {
        this.trie.clear();
    }

    public IMapSetIndex.IMapSetDiff<String, V> computeDiff(IMapSetIndex<String, V> otherFuture) {
        return this.trie.computeDiff(otherFuture);
    }

    public ClosableIterator<V> constraintIterator(Constraint<String> keyConstraint) {
        assert (keyConstraint != null);
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.constraintIterator with keyConstraint=" + keyConstraint);
        }
        return this.trie.constraintIterator(keyConstraint);
    }

    public boolean contains(Constraint<String> keyConstraint, Constraint<V> entryConstraint) {
        boolean result = this.trie.contains(keyConstraint, entryConstraint);
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.contains keyConstraint=" + keyConstraint + "; entryConstraint=" + entryConstraint + " ? => " + result);
        }
        return result;
    }

    public boolean contains(String key, V entry) {
        boolean result = this.trie.contains(key, entry);
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.contains key=" + key + "; entry=" + entry + " ? => " + result);
        }
        return result;
    }

    public boolean containsKey(String key) {
        boolean result = this.trie.containsKey(key);
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.containsKey='" + key + "' ? => " + result);
        }
        return result;
    }

    public boolean deIndex(String key1) {
        return this.trie.deIndex(key1);
    }

    public boolean deIndex(String key1, V entry) {
        return this.trie.deIndex(key1, entry);
    }

    public boolean index(String key1, V entry) {
        return this.trie.index(key1, entry);
    }

    public boolean isEmpty() {
        return this.trie.isEmpty();
    }

    public ClosableIterator<String> keyIterator() {
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.keyIterator");
        }
        return this.trie.keyIterator();
    }

    public IEntrySet<V> lookup(String key) {
        IEntrySet result = this.trie.lookup(key);
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.lookup '" + key + "' = " + result);
        }
        return result;
    }

    public ClosableIterator<KeyEntryTuple<String, V>> tupleIterator(Constraint<String> keyConstraint, Constraint<V> entryConstraint) {
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.tupleIterator");
        }
        return this.trie.tupleIterator(keyConstraint, entryConstraint);
    }

    public ClosableIterator<V> executeQuery(FragmentQuery<V> fragmentQuery) {
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.query " + fragmentQuery);
        }
        ClosableIterator it = this.trie.valueIterator(fragmentQuery, fragmentQuery.getOptionalValueFilter());
        if (fragmentQuery.getMaxResults() < Integer.MAX_VALUE) {
            return Iterators.limit((Iterator)it, (int)fragmentQuery.getMaxResults());
        }
        return it;
    }

    private static <V extends Serializable> void addAllWithFilterAndLimit(IEntrySet<V> entrySet, FragmentQuery<V> fragmentQuery, Set<V> result) {
        Iterator it = entrySet.iterator();
        if (fragmentQuery.isFiltered()) {
            it = Iterators.filter((Iterator)it, fragmentQuery.getOptionalValueFilter());
        }
        if (fragmentQuery.isLimited()) {
            for (int spaceLeft = fragmentQuery.getMaxResults() - result.size(); it.hasNext() && spaceLeft > 0; --spaceLeft) {
                result.add(it.next());
            }
        } else {
            Iterators.addAll((Iterator)it, result);
        }
    }

    private static <V extends Serializable> Set<V> toSetWithFilterAndLimit(IEntrySet<V> entrySet, FragmentQuery<V> fragmentQuery) {
        if (!fragmentQuery.isFiltered() && !fragmentQuery.isLimited()) {
            return entrySet.toSet();
        }
        SmallFastListBasedSet result = new SmallFastListBasedSet(entrySet.size());
        FragmentIndex.addAllWithFilterAndLimit(entrySet, fragmentQuery, result);
        return result;
    }

    public Set<V> executeQueryAsSet(FragmentQuery<V> fragmentQuery) {
        Set<Object> result;
        ClosableIterator entrySetIt = this.trie.valueAsEntrySetIterator(fragmentQuery);
        IEntrySet entrySet = (IEntrySet)entrySetIt.next();
        if (entrySet == null) {
            entrySetIt.close();
            result = Collections.emptySet();
        } else if (!entrySetIt.hasNext()) {
            entrySetIt.close();
            result = FragmentIndex.toSetWithFilterAndLimit(entrySet, fragmentQuery);
        } else {
            result = new HashSet();
            do {
                FragmentIndex.addAllWithFilterAndLimit(entrySet, fragmentQuery, result);
                entrySet = (IEntrySet)entrySetIt.next();
            } while (entrySetIt.hasNext());
            entrySetIt.close();
        }
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.query " + fragmentQuery + " => " + result);
        }
        return result;
    }

    public ClosableIterator<Set<V>> executeQueryAsSets(final FragmentQuery<V> fragmentQuery) {
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.executeQueryAsSets " + fragmentQuery);
        }
        ClosableIterator entrySetIt = this.trie.valueAsEntrySetIterator(fragmentQuery);
        ClosableIterator setIt = Iterators.transform((Iterator)entrySetIt, (ITransformer)new ITransformer<IEntrySet<V>, Set<V>>(){

            public Set<V> transform(IEntrySet<V> entrySet) {
                if (fragmentQuery.getOptionalValueFilter() == null && !fragmentQuery.isLimited()) {
                    return entrySet.toSet();
                }
                Iterator it = entrySet.iterator();
                if (fragmentQuery.getOptionalValueFilter() != null) {
                    it = Iterators.filter((Iterator)it, fragmentQuery.getOptionalValueFilter());
                }
                if (!it.hasNext()) {
                    return null;
                }
                HashSet set = new HashSet();
                Iterators.addAll((Iterator)it, set);
                return set;
            }
        });
        setIt = Iterators.filter((Iterator)setIt, (IFilter)new IFilter<Set<V>>(){

            public boolean matches(Set<V> entry) {
                return entry != null;
            }
        });
        if (fragmentQuery.isLimited()) {
            setIt = Iterators.limit((Iterator)setIt, (int)fragmentQuery.getMaxResults());
        }
        return setIt;
    }

    FragmentQuery<V> createQuery(String fragment, boolean prefixMatch) {
        return FragmentQuery.create(this, fragment, prefixMatch);
    }

    public void dump() {
        this.trie.dump();
    }

    public Pair<Integer, Set<V>> getLongestMatch(String s, int start) {
        Pair result = this.trie.getLongestMatch(s, start);
        if (log.isTraceEnabled()) {
            log.trace("FragmentIndex.longestMatch for '" + s + "' start:" + start + " =" + result);
        }
        return result;
    }

    public String toDebugString() {
        return this.trie.toDebugString();
    }

    public String toString(String indent) {
        return indent + this.trie.toDebugString();
    }

    public void setInternalIndexState(SmallTrieStringMapSetIndex<V> indexState) {
        this.trie = indexState;
    }

    public SmallTrieStringMapSetIndex<V> getInternalIndexState() {
        return this.trie;
    }

    public int size() {
        return this.trie.size();
    }
}

