/*
 * Decompiled with CFR 0.152.
 */
package de.xam.json;

import de.xam.json.JSONArray;
import de.xam.json.JSONObject;
import java.util.Stack;
import org.xydra.core.serialize.json.JSONException;
import org.xydra.core.serialize.json.SAJ;

public class BuilderSAJ
implements SAJ {
    private final Stack<Object> parsed = new Stack();
    private String key = null;
    private Object result;

    public void arrayEnd() {
        assert (!this.parsed.isEmpty() && this.parsed.peek().getClass().equals(JSONArray.class));
        if (this.parsed.size() > 1) {
            this.result = this.parsed.peek();
        }
        this.parsed.pop();
    }

    public void arrayStart() throws JSONException {
        JSONArray jsonArray = new JSONArray();
        this.linkToParent(jsonArray);
        this.parsed.push(jsonArray);
    }

    public void objectEnd() {
        assert (!this.parsed.isEmpty() && this.parsed.peek().getClass().equals(JSONObject.class));
        if (this.parsed.size() > 1) {
            this.result = this.parsed.peek();
        }
        this.parsed.pop();
    }

    public void objectStart() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        this.linkToParent(jsonObject);
        this.parsed.push(jsonObject);
    }

    private void linkToParent(Object jsonThing) throws JSONException {
        if (this.parsed.isEmpty()) {
            this.parsed.push(jsonThing);
        } else {
            Object top = this.parsed.peek();
            if (top instanceof JSONObject && this.key != null) {
                JSONObject jo = (JSONObject)top;
                jo.put(this.key, jsonThing);
                this.key = null;
            } else if (top instanceof JSONArray) {
                JSONArray ja = (JSONArray)top;
                ja.put(jsonThing);
            } else {
                throw new JSONException("Unexpected top stack element " + this.parsed);
            }
        }
    }

    public void onBoolean(boolean b) throws JSONException {
        Boolean bool = new Boolean(b);
        this.linkToParent(bool);
    }

    public void onDouble(double d) throws JSONException {
        Double doub = new Double(d);
        this.linkToParent(doub);
    }

    public void onInteger(int i) throws JSONException {
        Integer in = new Integer(i);
        this.linkToParent(in);
    }

    public void onKey(String key) {
        assert (this.key == null);
        this.key = key;
    }

    public void onLong(long l) throws JSONException {
        Long lo = new Long(l);
        this.linkToParent(lo);
    }

    public void onNull() throws JSONException {
        this.linkToParent(null);
    }

    public void onString(String s) throws JSONException {
        this.linkToParent(s);
    }

    public Object getParsed() {
        if (this.result != null) {
            return this.result;
        }
        assert (this.parsed.size() == 1);
        return this.parsed.peek();
    }
}

