/*
 * Decompiled with CFR 0.152.
 */
package de.xam.ksource.impl.jspwiki;

import de.xam.cmodel.fact.ChangeDatas;
import de.xam.cmodel.fact.IChangeData;
import de.xam.itemset.IItem;
import de.xam.itemset.IItemSet;
import de.xam.itemset.impl.ItemSets;
import de.xam.jspwiki.VersioningFileProvider;
import de.xam.kfacet.impl.wiki.WikiConfig;
import de.xam.kfacet.impl.wiki.WikiFacet;
import de.xam.kfacet.impl.wiki.WikiItem;
import de.xam.kfacet.impl.wiki.spi.IEntity2Href;
import de.xam.ksource.ISourceItem;
import de.xam.ksource.impl.jspwiki.JspWikiSource;
import de.xam.ksource.impl.jspwiki.MaxWikiConfig;
import de.xam.ksource.impl.jspwiki.VocabularySourceJspWiki;
import de.xam.mybase.model.api.IMyBase;
import de.xam.mybase.model.names.CanonicalName;
import de.xam.mybase.model.names.IdManager;
import java.io.IOException;
import org.xydra.base.Base;
import org.xydra.base.XId;
import org.xydra.base.id.XidCodec;
import org.xydra.base.value.XV;
import org.xydra.base.value.XValue;
import org.xydra.index.query.Pair;

public class JspWikiSourceItem
implements ISourceItem {
    private final String pageName;
    private final JspWikiSource source;

    private static void setJspWikiLastModified(IItem item, long timestamp) {
        item.setAttribute(VocabularySourceJspWiki.ATTRIBUTE_JSPWIKI_LASTMODIFIED.id(), (XValue)XV.toValue((long)timestamp));
    }

    private static void setJspWikiVersion(IItem item, long version) {
        item.setAttribute(VocabularySourceJspWiki.ATTRIBUTE_JSPWIKI_VERSION.id(), (XValue)XV.toValue((long)version));
    }

    public JspWikiSourceItem(JspWikiSource source, String pageName) {
        this.source = source;
        this.pageName = pageName;
    }

    private IItem getItem() {
        IChangeData changeData = ChangeDatas.createWithCreationDate_Now((String)"JspWikiSourceItem", (String)this.getPageName());
        assert (this.getPageName() != null);
        CanonicalName cn = CanonicalName.create((String)this.getPageName());
        String canonical = cn.getCanonical(false);
        String pageIdStr = XidCodec.encode((String)canonical, (int)80);
        XId pageId = Base.toId((String)("wiki-" + pageIdStr));
        IItem item = ItemSets.getOrCreateItemWithStringContent((IItemSet)this.source.itemSet, (XId)pageId, (String)this.getPageName(), (IChangeData)changeData);
        item.setIsReference(true);
        return item;
    }

    private Pair<Long, Integer> getLastModifiedDateAndVersionInJspWiki() {
        VersioningFileProvider.VersionedTextFile vtf = this.source.homewikiSource.getVersionedTextFile(this.getPageName());
        int version = vtf.getCurrentVersionNumber();
        long timestamp = vtf.timestamp(version);
        return new Pair((Object)timestamp, (Object)version);
    }

    public String getLocalStringId() {
        assert (this.getPageName() != null);
        CanonicalName cn = CanonicalName.create((String)this.getPageName());
        return IdManager.normalizeTruncateAndEncodeToId((CanonicalName)cn, (boolean)true).toString();
    }

    String getPageName() {
        return this.pageName;
    }

    private String getWikiSourceFromJspwiki() {
        try {
            String wikiSource = this.source.homewikiSource.getWikiSource(this.getPageName());
            return wikiSource;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUpToDate(IItemSet myBase) {
        long lastUpdateInMyBase = ChangeDatas.getLastCreationOrModifiedDate((IChangeData)this.getItem().getChangeData());
        long lastUpdateInJspWiki = (Long)this.getLastModifiedDateAndVersionInJspWiki().getFirst();
        return lastUpdateInJspWiki == lastUpdateInMyBase;
    }

    public void parseAgain() {
        IItem item = this.getItem();
        String wikiSource = WikiItem.getWikiSource((IItem)item);
        WikiFacet.parseToHtmlWithSideEffects((IMyBase)this.source.myBase, (IEntity2Href)this.source.entity2Href, (IItem)item, (String)wikiSource, (boolean)false, (boolean)true, (boolean)false);
    }

    void readDataAndParse(boolean createManualLinks, boolean createAutoLinks) {
        if (!WikiConfig.isBuiltIn((String)this.getPageName()) && !MaxWikiConfig.isSelected(this.getPageName())) {
            return;
        }
        if (this.isUpToDate(this.source.itemSet)) {
            return;
        }
        String wikiSource = this.getWikiSourceFromJspwiki();
        IItem item = this.getItem();
        WikiFacet.setWikiSource((IItem)item, (String)wikiSource);
        this.setTimeAndVersionInMyBase(item);
        WikiFacet.parseToHtmlWithSideEffects((IMyBase)this.source.myBase, (IEntity2Href)this.source.entity2Href, (IItem)item, (String)wikiSource, (boolean)createManualLinks, (boolean)createAutoLinks, (boolean)false);
    }

    public void readDataToMyBase(IItemSet itemSet) {
        if (this.isUpToDate(itemSet)) {
            return;
        }
        this.readDataAndParse(true, true);
    }

    private void setTimeAndVersionInMyBase(IItem item) {
        Pair<Long, Integer> dateAndVersionPair = this.getLastModifiedDateAndVersionInJspWiki();
        JspWikiSourceItem.setJspWikiLastModified(item, (Long)dateAndVersionPair.getFirst());
        JspWikiSourceItem.setJspWikiVersion(item, ((Integer)dateAndVersionPair.getSecond()).intValue());
    }

    public void writeBackToSource(IItemSet itemSet) throws IOException, UnsupportedOperationException {
        IItem item = this.getItem();
        assert (item != null) : "" + this.getPageName();
        assert (WikiItem.hasWikiText((IItem)item));
        String wikiSource = WikiItem.getWikiSource((IItem)item);
        this.source.homewikiSource.setWikiSource(this.getPageName(), wikiSource, false);
        this.setTimeAndVersionInMyBase(item);
    }
}

