/*
 * Decompiled with CFR 0.152.
 */
package de.xam.packagechaos.architecture;

import de.xam.packagechaos.Package;
import de.xam.packagechaos.architecture.Layer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class Architecture {
    private static final Logger log = LoggerFactory.getLogger(Architecture.class);
    private final Set<Layer> layers = new HashSet<Layer>();
    private final String[] scopes;
    private final Set<Class<?>> ignoredTypes = new HashSet();
    private final Map<String, Layer> prefix2layer = new HashMap<String, Layer>();

    public boolean isPlannedDependency(Package a, Package b) {
        if (Architecture.isToJavaPackage(a, b)) {
            log.debug("Dependency to java.* is always allowed");
            return true;
        }
        for (Layer layer : this.layers) {
            if (layer.contains(a) && layer.contains(b)) {
                log.debug(a + " and " + b + " are in the same layer " + layer);
                return true;
            }
            for (Layer lower : layer.getLowerLayers()) {
                if (!layer.contains(a) || !lower.contains(b)) continue;
                log.debug(a + " can access " + b + " in a lower layer");
                return true;
            }
            if (layer.contains(a) && layer.hasAccessToAllPackages()) {
                log.debug(a + " can access *");
                return true;
            }
            if (!layer.contains(b) || !layer.canBeAccessedFromAllPackages()) continue;
            log.debug("* can access " + b);
            return true;
        }
        log.debug(a + " should not access " + b);
        return false;
    }

    private static boolean hasLevelFive(Package a, Package b) {
        return a.depth() >= 5 || b.depth() >= 5;
    }

    private boolean isWithinScope(Package a, Package b) {
        return this.isWithinScope(a) && this.isWithinScope(b);
    }

    private boolean isWithinScope(Package p) {
        for (String scope : this.scopes) {
            if (!p.getName().startsWith(scope)) continue;
            return true;
        }
        return false;
    }

    private static boolean isToNeighbour(Package a, Package b) {
        return !a.equals(b) && a.getParentPackageName().equals(b.getParentPackageName());
    }

    private static boolean isToJavaPackage(Package a, Package b) {
        return b.getName().startsWith("java.");
    }

    private static boolean isToParent(Package a, Package b) {
        return a.getName().startsWith(b.getName());
    }

    public Architecture(String ... packageNamePrefixes) {
        this.scopes = packageNamePrefixes;
    }

    public ArchitectureBuilder setLowestLayer(String packageNamePrefix) {
        return new ArchitectureBuilder(packageNamePrefix);
    }

    public Architecture allowAcessFromEveryPackage(String packageNamePrefix) {
        Layer currentLayer = this.defineLayer(packageNamePrefix);
        currentLayer.setAllowAccessFromEveryPackage(true);
        return this;
    }

    public Architecture ignoreForNow(String packageNamePrefix) {
        Layer currentLayer = this.defineLayer(packageNamePrefix);
        currentLayer.setAllowAccessFromEveryPackage(true);
        currentLayer.setAllowAccessToEveryPackage(true);
        this.layers.add(currentLayer);
        return this;
    }

    public boolean toBeShown(Package a, Package b, Set<String> causes) {
        if (a.equals(b)) {
            log.debug("Both in same package " + a);
            return false;
        }
        if (!this.isWithinScope(a, b)) {
            log.debug("Not both in scope " + a + " and " + b);
            return false;
        }
        assert (causes != null);
        assert (causes.size() > 0);
        Iterator<String> it = causes.iterator();
        while (it.hasNext()) {
            String cause = it.next();
            for (Class<?> ignored : this.ignoredTypes) {
                if (!ignored.getCanonicalName().equals(cause)) continue;
                it.remove();
            }
        }
        if (causes.isEmpty()) {
            log.debug("No relevant causes to show " + a + " to " + b);
            return false;
        }
        if (Architecture.isToParent(a, b)) {
            log.debug("Legal access from child " + a + " to parent " + b);
            return false;
        }
        if (Architecture.isToParent(b, a)) {
            log.debug("Legal access from child " + b + " to parent " + a);
            return false;
        }
        return !this.isPlannedDependency(a, b);
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public Layer defineLayer(String packageNamePrefix) {
        Layer layer = this.prefix2layer.get(packageNamePrefix);
        if (layer == null) {
            layer = new Layer(packageNamePrefix, false, false);
            this.prefix2layer.put(packageNamePrefix, layer);
            this.layers.add(layer);
        }
        return layer;
    }

    public void ignoreType(Class<?> type) {
        this.ignoredTypes.add(type);
    }

    public class ArchitectureBuilder {
        private Layer currentLayer;

        private ArchitectureBuilder(String packageNamePrefix) {
            this.currentLayer = Architecture.this.defineLayer(packageNamePrefix);
        }

        public ArchitectureBuilder addLayerOnTop(String packageNamePrefix) {
            this.currentLayer = Architecture.this.defineLayer(packageNamePrefix);
            for (Layer lower : Architecture.this.layers) {
                this.currentLayer.mayAccess(lower);
            }
            return this;
        }
    }
}

