/*
 * Decompiled with CFR 0.152.
 */
package de.xam.packagechaos;

import de.xam.dotgraph.Graph;
import de.xam.packagechaos.IDependencyFilter;
import de.xam.packagechaos.Package;
import de.xam.packagechaos.Project;
import de.xam.packagechaos.architecture.Architecture;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.xydra.log.api.Logger;
import org.xydra.log.api.LoggerFactory;

public class PackageChaos {
    private static final Logger log = LoggerFactory.getLogger(PackageChaos.class);
    private final Architecture arch;
    private final File resultFile;
    private final Project project;

    public PackageChaos(Architecture arch, File result) {
        this.arch = arch;
        this.resultFile = result;
        this.project = new Project();
    }

    public void analyseAndRender(String path) throws IOException {
        this.readImportsFromDir(path);
        this.renderDotGraph();
    }

    public void readImportsFromDir(String path) throws IOException {
        File f = new File(path);
        assert (f.exists());
        assert (f.isDirectory());
        this.project.scanDir(f);
    }

    public Project getProject() {
        return this.project;
    }

    public void renderDotGraph() throws IOException {
        log.info("Index has " + this.project.packageCount() + " packages");
        Graph graph = new Graph("main");
        graph.setLabelRenderer(new Graph.ILabelRenderer(){

            public String render(String s) {
                String p = s;
                for (String scope : PackageChaos.this.arch.getScopes()) {
                    if (scope.length() <= 0 || !s.startsWith(scope)) continue;
                    p = s.substring((scope + ".").length());
                    break;
                }
                return "<" + p.replace(".", ".\n") + ">";
            }
        });
        this.project.addLinksToChildPackages();
        System.out.println("--- Packages ---");
        this.project.dump();
        this.project.addPackagesAsSubgraphs(graph, this.project, new IDependencyFilter(){

            @Override
            public boolean shouldBeShown(Package a, Package b, Set<String> causes) {
                return PackageChaos.this.arch.toBeShown(a, b, causes);
            }
        });
        graph.pruneEmptySubGraphs();
        System.out.println("--- Graph ---");
        graph.dump("");
        File temp = new File(this.resultFile.getAbsoluteFile() + ".temp");
        graph.writeTo(temp);
        temp.renameTo(this.resultFile);
        log.info("Written " + graph.size() + " edges to DOT file");
    }

    public void setShowCauses(boolean b) {
        this.project.showCauses = b;
    }
}

